"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_GLOBAL_APPLY_FILTER = void 0;
exports.createFilterAction = createFilterAction;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _services = require("../services");
var _apply_filters = require("../apply_filters");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // for cleanup esFilters need to fix the issue https://github.com/elastic/kibana/issues/131292
const ACTION_GLOBAL_APPLY_FILTER = exports.ACTION_GLOBAL_APPLY_FILTER = 'ACTION_GLOBAL_APPLY_FILTER';
async function isCompatible(context) {
  return context.filters !== undefined;
}
function createFilterAction(filterManager, timeFilter, theme, id = ACTION_GLOBAL_APPLY_FILTER, type = ACTION_GLOBAL_APPLY_FILTER) {
  return {
    type,
    id,
    order: 100,
    getIconType: () => 'filter',
    getDisplayName: () => {
      return _i18n.i18n.translate('unifiedSearch.filter.applyFilterActionTitle', {
        defaultMessage: 'Apply filter to current view'
      });
    },
    isCompatible,
    execute: async ({
      filters,
      timeFieldName,
      controlledBy
    }) => {
      if (!filters) {
        throw new Error('Applying a filter requires a filter');
      }
      if (!(await isCompatible({
        filters
      }))) {
        throw new _public2.IncompatibleActionError();
      }
      let selectedFilters = filters;
      if (selectedFilters.length > 1) {
        const indexPatterns = await Promise.all(filters.map(filter => {
          return (0, _services.getIndexPatterns)().get(filter.meta.index);
        }));
        const filterSelectionPromise = new Promise(resolve => {
          const overlay = (0, _services.getOverlays)().openModal((0, _public.toMountPoint)((0, _apply_filters.applyFiltersPopover)(filters, indexPatterns, () => {
            overlay.close();
            resolve([]);
          }, filterSelection => {
            overlay.close();
            resolve(filterSelection);
          }), {
            theme$: theme.theme$
          }), {
            'data-test-subj': 'test'
          });
        });
        selectedFilters = await filterSelectionPromise;
      }

      // remove existing filters for control prior to adding new filtes for control
      if (controlledBy) {
        filterManager.getFilters().forEach(filter => {
          if (filter.meta.controlledBy === controlledBy) {
            filterManager.removeFilter(filter);
          }
        });
      }
      if (timeFieldName) {
        const {
          extractTimeFilter
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
        const {
          timeRangeFilter,
          restOfFilters
        } = extractTimeFilter(timeFieldName, selectedFilters);
        filterManager.addFilters(restOfFilters);
        if (timeRangeFilter) {
          changeTimeFilter(timeFilter, timeRangeFilter);
        }
      } else {
        filterManager.addFilters(selectedFilters);
      }
    }
  };
}
async function changeTimeFilter(timeFilter, filter) {
  const {
    convertRangeFilterToTimeRange
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
  timeFilter.setTime(convertRangeFilterToTimeRange(filter));
}