"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeTablesFromLensAttributes = exports.enrichLensAttributesWithTablesData = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const enrichLensAttributesWithTablesData = ({
  attributes,
  table
}) => {
  var _attributes$state$dat;
  if (!attributes.state.datasourceStates.textBased) {
    return attributes;
  }
  const layers = (_attributes$state$dat = attributes.state.datasourceStates.textBased) === null || _attributes$state$dat === void 0 ? void 0 : _attributes$state$dat.layers;
  if (!layers) {
    return attributes;
  }
  const updatedAttributes = {
    ...attributes,
    state: {
      ...attributes.state,
      datasourceStates: {
        ...attributes.state.datasourceStates,
        textBased: {
          ...attributes.state.datasourceStates.textBased,
          layers: {}
        }
      }
    }
  };
  for (const key of Object.keys(layers)) {
    const newLayer = {
      ...layers[key],
      table
    };
    if (!table) {
      delete newLayer.table;
    }
    updatedAttributes.state.datasourceStates.textBased.layers[key] = newLayer;
  }
  return updatedAttributes;
};
exports.enrichLensAttributesWithTablesData = enrichLensAttributesWithTablesData;
const removeTablesFromLensAttributes = attributes => {
  return enrichLensAttributesWithTablesData({
    attributes,
    table: undefined
  });
};
exports.removeTablesFromLensAttributes = removeTablesFromLensAttributes;