"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStateService = void 0;
var _rxjs = require("rxjs");
var _ = require("../..");
var _local_storage_utils = require("../utils/local_storage_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The current state of the container
 */

/**
 * The options used to initialize the comntainer state
 */

/**
 * The service used to manage the state of the container
 */

const createStateService = options => {
  const {
    services,
    localStorageKeyPrefix,
    initialState
  } = options;
  let initialChartHidden = false;
  let initialTopPanelHeight;
  let initialBreakdownField;
  if (localStorageKeyPrefix) {
    var _getChartHidden;
    initialChartHidden = (_getChartHidden = (0, _local_storage_utils.getChartHidden)(services.storage, localStorageKeyPrefix)) !== null && _getChartHidden !== void 0 ? _getChartHidden : false;
    initialTopPanelHeight = (0, _local_storage_utils.getTopPanelHeight)(services.storage, localStorageKeyPrefix);
    initialBreakdownField = (0, _local_storage_utils.getBreakdownField)(services.storage, localStorageKeyPrefix);
  }
  const state$ = new _rxjs.BehaviorSubject({
    breakdownField: initialBreakdownField,
    chartHidden: initialChartHidden,
    currentSuggestionContext: undefined,
    lensRequestAdapter: undefined,
    timeInterval: 'auto',
    topPanelHeight: initialTopPanelHeight,
    totalHitsResult: undefined,
    totalHitsStatus: _.UnifiedHistogramFetchStatus.uninitialized,
    ...initialState
  });
  const updateState = stateUpdate => {
    state$.next({
      ...state$.getValue(),
      ...stateUpdate
    });
  };
  return {
    state$,
    setChartHidden: chartHidden => {
      if (localStorageKeyPrefix) {
        (0, _local_storage_utils.setChartHidden)(services.storage, localStorageKeyPrefix, chartHidden);
      }
      updateState({
        chartHidden
      });
    },
    setTopPanelHeight: topPanelHeight => {
      if (localStorageKeyPrefix) {
        (0, _local_storage_utils.setTopPanelHeight)(services.storage, localStorageKeyPrefix, topPanelHeight);
      }
      updateState({
        topPanelHeight
      });
    },
    setBreakdownField: breakdownField => {
      if (localStorageKeyPrefix) {
        (0, _local_storage_utils.setBreakdownField)(services.storage, localStorageKeyPrefix, breakdownField);
      }
      updateState({
        breakdownField
      });
    },
    setCurrentSuggestionContext: suggestionContext => {
      updateState({
        currentSuggestionContext: suggestionContext
      });
    },
    setTimeInterval: timeInterval => {
      updateState({
        timeInterval
      });
    },
    setLensRequestAdapter: lensRequestAdapter => {
      updateState({
        lensRequestAdapter
      });
    },
    setLensAdapters: lensAdapters => {
      updateState({
        lensAdapters
      });
    },
    setLensEmbeddableOutput$: lensEmbeddableOutput$ => {
      updateState({
        lensEmbeddableOutput$
      });
    },
    setTotalHits: totalHits => {
      updateState(totalHits);
    }
  };
};
exports.createStateService = createStateService;