"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChartAggConfigs = getChartAggConfigs;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper function to get the agg configs required for the Unified Histogram chart request
 */
function getChartAggConfigs({
  dataView,
  timeInterval,
  timeRange,
  data
}) {
  const visStateAggs = [{
    type: 'count',
    schema: 'metric'
  }, {
    type: 'date_histogram',
    schema: 'segment',
    params: {
      field: dataView.timeFieldName,
      interval: timeInterval,
      timeRange
    }
  }];
  return data.search.aggs.createAggConfigs(dataView, visStateAggs);
}