"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarSelector = exports.EMPTY_OPTION = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EMPTY_OPTION = exports.EMPTY_OPTION = '__EMPTY_SELECTOR_OPTION__';
const ToolbarSelector = ({
  'data-test-subj': dataTestSubj,
  'data-selected-value': dataSelectedValue,
  buttonLabel,
  popoverTitle,
  options,
  searchable,
  onChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [searchTerm, setSearchTerm] = (0, _react.useState)();
  const [labelPopoverDisabled, setLabelPopoverDisabled] = (0, _react.useState)(false);
  const disableLabelPopover = (0, _react.useCallback)(() => setLabelPopoverDisabled(true), []);
  const enableLabelPopover = (0, _react.useCallback)(() => setTimeout(() => setLabelPopoverDisabled(false)), []);
  const onSelectionChange = (0, _react.useCallback)(newOptions => {
    const chosenOption = newOptions.find(({
      checked
    }) => checked === 'on');
    onChange === null || onChange === void 0 ? void 0 : onChange(chosenOption !== null && chosenOption !== void 0 && chosenOption.value && (chosenOption === null || chosenOption === void 0 ? void 0 : chosenOption.value) !== EMPTY_OPTION ? chosenOption : undefined);
    setIsOpen(false);
    disableLabelPopover();
  }, [disableLabelPopover, onChange]);
  const searchProps = (0, _react.useMemo)(() => searchable ? {
    id: `${dataTestSubj}SelectableInput`,
    'data-test-subj': `${dataTestSubj}SelectorSearch`,
    compressed: true,
    placeholder: _i18n.i18n.translate('unifiedHistogram.toolbarSelectorPopover.searchPlaceholder', {
      defaultMessage: 'Search'
    }),
    onChange: value => setSearchTerm(value)
  } : undefined, [dataTestSubj, searchable, setSearchTerm]);
  const panelMinWidth = (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(options, ['label']) + 2 * euiTheme.base; // plus extra width for the right Enter button

  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: dataTestSubj,
    ownFocus: true,
    initialFocus: searchable ? `#${dataTestSubj}SelectableInput` : `#${dataTestSubj}Selectable_listbox`,
    panelProps: {
      css: searchable ? (0, _react2.css)`
              min-width: ${panelMinWidth}px;
            ` : (0, _react2.css)`
              width: ${panelMinWidth}px;
            `
    },
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: labelPopoverDisabled ? undefined : buttonLabel,
      delay: "long",
      display: "block"
    }, /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      size: "s",
      css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.medium};
              width: 100%;
              min-width: 0;
              max-width: ${euiTheme.base * 20}px;
            `,
      "data-test-subj": `${dataTestSubj}Button`,
      "data-selected-value": dataSelectedValue,
      "aria-label": popoverTitle,
      label: buttonLabel,
      onClick: () => setIsOpen(!isOpen),
      onBlur: enableLabelPopover
    })),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, popoverTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, (0, _extends2.default)({
    id: `${dataTestSubj}Selectable`,
    singleSelection: true,
    "aria-label": popoverTitle,
    "data-test-subj": `${dataTestSubj}Selectable`,
    options: options,
    onChange: onSelectionChange,
    listProps: {
      truncationProps: {
        truncation: 'middle'
      },
      isVirtualized: searchable
    }
  }, searchable ? {
    searchable,
    searchProps,
    noMatchesMessage: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedHistogram.toolbarSelectorPopover.noResults",
      defaultMessage: "No results found for {term}",
      values: {
        term: /*#__PURE__*/_react.default.createElement("strong", null, searchTerm)
      }
    }))
  } : {}), (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    css: {
      paddingBottom: 0
    }
  }, search), list)));
};
exports.ToolbarSelector = ToolbarSelector;