"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BreakdownFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fieldUtils = require("@kbn/field-utils");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _field_supports_breakdown = require("../utils/field_supports_breakdown");
var _toolbar_selector = require("./toolbar_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const BreakdownFieldSelector = ({
  dataView,
  breakdown,
  onBreakdownFieldChange
}) => {
  var _breakdown$field2, _breakdown$field3, _breakdown$field4;
  const fieldOptions = (0, _react.useMemo)(() => {
    const options = dataView.fields.filter(_field_supports_breakdown.fieldSupportsBreakdown).map(field => {
      var _breakdown$field;
      return {
        key: field.name,
        label: field.displayName,
        value: field.name,
        checked: (breakdown === null || breakdown === void 0 ? void 0 : (_breakdown$field = breakdown.field) === null || _breakdown$field === void 0 ? void 0 : _breakdown$field.name) === field.name ? 'on' : undefined,
        prepend: /*#__PURE__*/_react.default.createElement("span", {
          css: (0, _react2.css)`
              .euiToken {
                vertical-align: middle;
              }
            `
        }, /*#__PURE__*/_react.default.createElement(_fieldUtils.FieldIcon, (0, _fieldUtils.getFieldIconProps)(field)))
      };
    }).sort((a, b) => a.label.toLowerCase().localeCompare(b.label.toLowerCase()));
    options.unshift({
      key: _toolbar_selector.EMPTY_OPTION,
      value: _toolbar_selector.EMPTY_OPTION,
      label: _i18n.i18n.translate('unifiedHistogram.breakdownFieldSelector.noBreakdownButtonLabel', {
        defaultMessage: 'No breakdown'
      }),
      checked: !(breakdown !== null && breakdown !== void 0 && breakdown.field) ? 'on' : undefined
    });
    return options;
  }, [dataView, breakdown.field]);
  const onChange = (0, _react.useCallback)(chosenOption => {
    const field = chosenOption !== null && chosenOption !== void 0 && chosenOption.value ? dataView.fields.find(currentField => currentField.name === chosenOption.value) : undefined;
    onBreakdownFieldChange === null || onBreakdownFieldChange === void 0 ? void 0 : onBreakdownFieldChange(field);
  }, [dataView.fields, onBreakdownFieldChange]);
  return /*#__PURE__*/_react.default.createElement(_toolbar_selector.ToolbarSelector, {
    "data-test-subj": "unifiedHistogramBreakdownSelector",
    "data-selected-value": breakdown === null || breakdown === void 0 ? void 0 : (_breakdown$field2 = breakdown.field) === null || _breakdown$field2 === void 0 ? void 0 : _breakdown$field2.name,
    searchable: true,
    buttonLabel: breakdown !== null && breakdown !== void 0 && (_breakdown$field3 = breakdown.field) !== null && _breakdown$field3 !== void 0 && _breakdown$field3.displayName ? _i18n.i18n.translate('unifiedHistogram.breakdownFieldSelector.breakdownByButtonLabel', {
      defaultMessage: 'Breakdown by {fieldName}',
      values: {
        fieldName: breakdown === null || breakdown === void 0 ? void 0 : (_breakdown$field4 = breakdown.field) === null || _breakdown$field4 === void 0 ? void 0 : _breakdown$field4.displayName
      }
    }) : _i18n.i18n.translate('unifiedHistogram.breakdownFieldSelector.noBreakdownButtonLabel', {
      defaultMessage: 'No breakdown'
    }),
    popoverTitle: _i18n.i18n.translate('unifiedHistogram.breakdownFieldSelector.breakdownFieldPopoverTitle', {
      defaultMessage: 'Select breakdown field'
    }),
    options: fieldOptions,
    onChange: onChange
  });
};

// eslint-disable-next-line import/no-default-export
exports.BreakdownFieldSelector = BreakdownFieldSelector;
var _default = exports.default = BreakdownFieldSelector;