"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewerTable = void 0;
require("./table.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _get_field_icon_type = require("@kbn/field-utils/src/utils/get_field_icon_type");
var _discoverUtils = require("@kbn/discover-utils");
var _fieldUtils = require("@kbn/field-utils");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _plugin = require("../../plugin");
var _table_cell_value = require("./table_cell_value");
var _table_cell_actions = require("./table_cell_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MOBILE_OPTIONS = {
  header: false
};
const PAGE_SIZE_OPTIONS = [25, 50, 100];
const DEFAULT_PAGE_SIZE = 25;
const PINNED_FIELDS_KEY = 'discover:pinnedFields';
const PAGE_SIZE = 'discover:pageSize';
const SEARCH_TEXT = 'discover:searchText';
const getPinnedFields = (dataViewId, storage) => {
  const pinnedFieldsEntry = storage.get(PINNED_FIELDS_KEY);
  if (typeof pinnedFieldsEntry === 'object' && pinnedFieldsEntry !== null && Array.isArray(pinnedFieldsEntry[dataViewId])) {
    return pinnedFieldsEntry[dataViewId].filter(cur => typeof cur === 'string');
  }
  return [];
};
const updatePinnedFieldsState = (newFields, dataViewId, storage) => {
  let pinnedFieldsEntry = storage.get(PINNED_FIELDS_KEY);
  pinnedFieldsEntry = typeof pinnedFieldsEntry === 'object' && pinnedFieldsEntry !== null ? pinnedFieldsEntry : {};
  storage.set(PINNED_FIELDS_KEY, {
    ...pinnedFieldsEntry,
    [dataViewId]: newFields
  });
};
const getPageSize = storage => {
  const pageSize = Number(storage.get(PAGE_SIZE));
  return pageSize && PAGE_SIZE_OPTIONS.includes(pageSize) ? pageSize : DEFAULT_PAGE_SIZE;
};
const updatePageSize = (newPageSize, storage) => {
  storage.set(PAGE_SIZE, newPageSize);
};
const getSearchText = storage => {
  return storage.get(SEARCH_TEXT) || '';
};
const updateSearchText = (0, _lodash.debounce)((newSearchText, storage) => storage.set(SEARCH_TEXT, newSearchText), 500);
const DocViewerTable = ({
  columns,
  columnsMeta,
  hit,
  dataView,
  hideActionsColumn,
  filter,
  onAddColumn,
  onRemoveColumn
}) => {
  const showActionsInsideTableCell = (0, _eui.useIsWithinBreakpoints)(['xl'], true);
  const {
    fieldFormats,
    storage,
    uiSettings
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const showMultiFields = uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS);
  const currentDataViewId = dataView.id;
  const [searchText, setSearchText] = (0, _react.useState)(getSearchText(storage));
  const [pinnedFields, setPinnedFields] = (0, _react.useState)(getPinnedFields(currentDataViewId, storage));
  const flattened = hit.flattened;
  const shouldShowFieldHandler = (0, _react.useMemo)(() => (0, _discoverUtils.getShouldShowFieldHandler)(Object.keys(flattened), dataView, showMultiFields), [flattened, dataView, showMultiFields]);
  const searchPlaceholder = _i18n.i18n.translate('unifiedDocViewer.docView.table.searchPlaceHolder', {
    defaultMessage: 'Search field names'
  });
  const mapping = (0, _react.useCallback)(name => dataView.fields.getByName(name), [dataView.fields]);
  const onToggleColumn = (0, _react.useCallback)(field => {
    if (!onRemoveColumn || !onAddColumn || !columns) {
      return;
    }
    if (columns.includes(field)) {
      onRemoveColumn(field);
    } else {
      onAddColumn(field);
    }
  }, [onRemoveColumn, onAddColumn, columns]);
  const onTogglePinned = (0, _react.useCallback)(field => {
    const newPinned = pinnedFields.includes(field) ? pinnedFields.filter(curField => curField !== field) : [...pinnedFields, field];
    updatePinnedFieldsState(newPinned, currentDataViewId, storage);
    setPinnedFields(newPinned);
  }, [currentDataViewId, pinnedFields, storage]);
  const fieldToItem = (0, _react.useCallback)((field, isPinned) => {
    var _fieldMapping$display;
    const fieldMapping = mapping(field);
    const displayName = (_fieldMapping$display = fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.displayName) !== null && _fieldMapping$display !== void 0 ? _fieldMapping$display : field;
    const columnMeta = columnsMeta === null || columnsMeta === void 0 ? void 0 : columnsMeta[field];
    const columnIconType = (0, _fieldUtils.getTextBasedColumnIconType)(columnMeta);
    const fieldType = columnIconType ? columnIconType // for text-based results types come separately
    : (0, _discoverUtils.isNestedFieldParent)(field, dataView) ? 'nested' : fieldMapping ? (0, _get_field_icon_type.getFieldIconType)(fieldMapping) : undefined;
    const ignored = (0, _discoverUtils.getIgnoredReason)(fieldMapping !== null && fieldMapping !== void 0 ? fieldMapping : field, hit.raw._ignored);
    return {
      action: {
        onToggleColumn,
        onFilter: filter,
        isActive: !!(columns !== null && columns !== void 0 && columns.includes(field)),
        flattenedField: flattened[field]
      },
      field: {
        field,
        displayName,
        fieldMapping,
        fieldType,
        scripted: Boolean(fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.scripted),
        pinned: isPinned,
        onTogglePinned
      },
      value: {
        formattedValue: (0, _discoverUtils.formatFieldValue)(hit.flattened[field], hit.raw, fieldFormats, dataView, fieldMapping),
        ignored
      }
    };
  }, [mapping, dataView, hit, onToggleColumn, filter, columns, columnsMeta, flattened, onTogglePinned, fieldFormats]);
  const handleOnChange = (0, _react.useCallback)(event => {
    const newSearchText = event.currentTarget.value;
    updateSearchText(newSearchText, storage);
    setSearchText(newSearchText);
  }, [storage]);
  const {
    pinnedItems,
    restItems
  } = Object.keys(flattened).sort((fieldA, fieldB) => {
    const mappingA = mapping(fieldA);
    const mappingB = mapping(fieldB);
    const nameA = !mappingA || !mappingA.displayName ? fieldA : mappingA.displayName;
    const nameB = !mappingB || !mappingB.displayName ? fieldB : mappingB.displayName;
    return nameA.localeCompare(nameB);
  }).reduce((acc, curFieldName) => {
    if (!shouldShowFieldHandler(curFieldName)) {
      return acc;
    }
    if (pinnedFields.includes(curFieldName)) {
      acc.pinnedItems.push(fieldToItem(curFieldName, true));
    } else {
      const fieldMapping = mapping(curFieldName);
      if (!(searchText !== null && searchText !== void 0 && searchText.trim()) || (0, _fieldUtils.fieldNameWildcardMatcher)({
        name: curFieldName,
        displayName: fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.displayName
      }, searchText)) {
        // filter only unpinned fields
        acc.restItems.push(fieldToItem(curFieldName, false));
      }
    }
    return acc;
  }, {
    pinnedItems: [],
    restItems: []
  });
  const {
    curPageIndex,
    pageSize,
    totalPages,
    startIndex,
    changePageIndex,
    changePageSize
  } = (0, _discoverUtils.usePager)({
    initialPageSize: getPageSize(storage),
    totalItems: restItems.length
  });
  const showPagination = totalPages !== 0;
  const onChangePageSize = (0, _react.useCallback)(newPageSize => {
    updatePageSize(newPageSize, storage);
    changePageSize(newPageSize);
  }, [changePageSize, storage]);
  const headers = [!hideActionsColumn && /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    key: "header-cell-actions",
    align: "left",
    width: showActionsInsideTableCell && filter ? 150 : 62,
    isSorted: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.fieldChooser.discoverField.actions",
    defaultMessage: "Actions"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    key: "header-cell-name",
    align: "left",
    width: "30%",
    isSorted: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.fieldChooser.discoverField.name",
    defaultMessage: "Field"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    key: "header-cell-value",
    align: "left",
    isSorted: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.fieldChooser.discoverField.value",
    defaultMessage: "Value"
  }))))];
  const renderRows = (0, _react.useCallback)(items => {
    return items.map(({
      action: {
        flattenedField,
        onFilter
      },
      field: {
        field,
        fieldMapping,
        fieldType,
        scripted,
        pinned
      },
      value: {
        formattedValue,
        ignored
      }
    }) => {
      var _fieldMapping$display2;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
        key: field,
        className: "kbnDocViewer__tableRow",
        isSelected: pinned
      }, !hideActionsColumn && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        key: field + '-actions',
        align: showActionsInsideTableCell ? 'left' : 'center',
        width: showActionsInsideTableCell ? undefined : 62,
        className: "kbnDocViewer__tableActionsCell",
        textOnly: false,
        mobileOptions: MOBILE_OPTIONS
      }, /*#__PURE__*/_react.default.createElement(_table_cell_actions.TableActions, {
        mode: showActionsInsideTableCell ? 'inline' : 'as_popover',
        field: field,
        pinned: pinned,
        fieldMapping: fieldMapping,
        flattenedField: flattenedField,
        onFilter: onFilter,
        onToggleColumn: onToggleColumn,
        ignoredValue: !!ignored,
        onTogglePinned: onTogglePinned
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        key: field + '-field-name',
        align: "left",
        width: "30%",
        className: "kbnDocViewer__tableFieldNameCell",
        textOnly: false,
        mobileOptions: MOBILE_OPTIONS
      }, /*#__PURE__*/_react.default.createElement(_unifiedDocViewer.FieldName, {
        fieldName: field,
        fieldType: fieldType,
        fieldMapping: fieldMapping,
        scripted: scripted,
        highlight: (0, _fieldUtils.getFieldSearchMatchingHighlight)((_fieldMapping$display2 = fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.displayName) !== null && _fieldMapping$display2 !== void 0 ? _fieldMapping$display2 : field, searchText)
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
        key: field + '-value',
        align: "left",
        className: "kbnDocViewer__tableValueCell",
        textOnly: false,
        mobileOptions: MOBILE_OPTIONS
      }, /*#__PURE__*/_react.default.createElement(_table_cell_value.TableFieldValue, {
        field: field,
        formattedValue: formattedValue,
        rawValue: flattenedField,
        ignoreReason: ignored
      })));
    });
  }, [hideActionsColumn, showActionsInsideTableCell, onToggleColumn, onTogglePinned, searchText]);
  const rowElements = [...renderRows(pinnedItems), ...renderRows(restItems.slice(startIndex, pageSize + startIndex))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "aria-label": searchPlaceholder,
    fullWidth: true,
    onChange: handleOnChange,
    placeholder: searchPlaceholder,
    value: searchText,
    "data-test-subj": "unifiedDocViewerFieldsSearchInput"
  })), rowElements.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiI18n, {
    token: "unifiedDocViewer.docViews.table.noFieldFound",
    default: "No fields found"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, headers), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, rowElements))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), showPagination && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    activePage: curPageIndex,
    itemsPerPage: pageSize,
    itemsPerPageOptions: PAGE_SIZE_OPTIONS,
    pageCount: totalPages,
    onChangeItemsPerPage: onChangePageSize,
    onChangePage: changePageIndex
  })));
};
exports.DocViewerTable = DocViewerTable;