"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_HEIGHT = exports.MAX_LINES_CLASSIC_TABLE = exports.MARGIN_BOTTOM = exports.DocViewerSource = void 0;
require("./source.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _discoverUtils = require("@kbn/discover-utils");
var _plugin = require("../../plugin");
var _hooks = require("../../hooks");
var _get_height = require("./get_height");
var _json_code_editor = require("../json_code_editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Ihe number of lines displayed without scrolling used for classic table, which renders the component
// inline limitation was necessary to enable virtualized scrolling, which improves performance
const MAX_LINES_CLASSIC_TABLE = exports.MAX_LINES_CLASSIC_TABLE = 500;
// Displayed margin of the code editor to the window bottom when rendered in the document explorer flyout
const MARGIN_BOTTOM = exports.MARGIN_BOTTOM = 25;
// Minimum height for the source content to guarantee minimum space when the flyout is scrollable.
const MIN_HEIGHT = exports.MIN_HEIGHT = 400;
const DocViewerSource = ({
  id,
  index,
  dataView,
  width,
  hasLineNumbers,
  textBasedHits,
  onRefresh
}) => {
  const [editor, setEditor] = (0, _react.useState)();
  const [editorHeight, setEditorHeight] = (0, _react.useState)();
  const [jsonValue, setJsonValue] = (0, _react.useState)('');
  const {
    uiSettings
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const useNewFieldsApi = !uiSettings.get(_discoverUtils.SEARCH_FIELDS_FROM_SOURCE);
  const useDocExplorer = !(0, _discoverUtils.isLegacyTableEnabled)({
    uiSettings,
    isTextBasedQueryMode: Array.isArray(textBasedHits)
  });
  const [requestState, hit] = (0, _hooks.useEsDocSearch)({
    id,
    index,
    dataView,
    requestSource: useNewFieldsApi,
    textBasedHits
  });
  (0, _react.useEffect)(() => {
    if (requestState === _unifiedDocViewer.ElasticRequestState.Found && hit) {
      setJsonValue(JSON.stringify(hit.raw, undefined, 2));
    }
  }, [requestState, hit]);

  // setting editor height
  // - classic view: based on lines height and count to stretch and fit its content
  // - explorer: to fill the available space of the document flyout
  (0, _react.useEffect)(() => {
    if (!editor) {
      return;
    }
    const editorElement = editor.getDomNode();
    if (!editorElement) {
      return;
    }
    const height = (0, _get_height.getHeight)(editor, useDocExplorer);
    if (height === 0) {
      return;
    }
    if (!jsonValue || jsonValue === '') {
      setEditorHeight(0);
    } else {
      setEditorHeight(height);
    }
  }, [editor, jsonValue, useDocExplorer, setEditorHeight]);
  const loadingState = /*#__PURE__*/_react.default.createElement("div", {
    className: "sourceViewer__loading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    className: "sourceViewer__loadingSpinner"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.loadingJSON",
    defaultMessage: "Loading JSON"
  })));
  const errorMessageTitle = /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.errorMessageTitle', {
    defaultMessage: 'An Error Occurred'
  }));
  const errorMessage = /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.errorMessage', {
    defaultMessage: 'Could not fetch data at this time. Refresh the tab to try again.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: onRefresh
  }, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.refresh', {
    defaultMessage: 'Refresh'
  })));
  const errorState = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: errorMessageTitle,
    body: errorMessage
  });
  if (requestState === _unifiedDocViewer.ElasticRequestState.Error || requestState === _unifiedDocViewer.ElasticRequestState.NotFound) {
    return errorState;
  }
  if (requestState === _unifiedDocViewer.ElasticRequestState.Loading || jsonValue === '') {
    return loadingState;
  }
  return /*#__PURE__*/_react.default.createElement(_json_code_editor.JSONCodeEditorCommonMemoized, {
    jsonValue: jsonValue,
    width: width,
    height: editorHeight,
    hasLineNumbers: hasLineNumbers,
    onEditorDidMount: editorNode => setEditor(editorNode)
  });
};
exports.DocViewerSource = DocViewerSource;