"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.version = exports.tag = exports.euiThemeVars = exports.euiLightVars = exports.euiDarkVars = exports.darkMode = exports._setDarkMode = void 0;
var _eui_theme_light = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_light.json"));
var _eui_theme_dark = _interopRequireDefault(require("@elastic/eui/dist/eui_theme_dark.json"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable-next-line @kbn/eslint/module_migration */

/* eslint-disable-next-line @kbn/eslint/module_migration */

const globals = typeof window === 'undefined' ? {} : window;
// in the Kibana app we can rely on this global being defined, but in
// some cases (like jest) the global is undefined
/** @deprecated theme can be dynamic now, access is discouraged */
const tag = exports.tag = globals.__kbnThemeTag__ || 'v8light';
/** @deprecated theme can be dynamic now, access is discouraged */
const version = exports.version = 8;
/** @deprecated theme can be dynamic now, access is discouraged */
const darkMode = exports.darkMode = tag.endsWith('dark');
const euiLightVars = exports.euiLightVars = _eui_theme_light.default;
const euiDarkVars = exports.euiDarkVars = _eui_theme_dark.default;
let isDarkMode = darkMode;
const _setDarkMode = mode => {
  isDarkMode = mode;
};

/**
 * EUI Theme vars that automatically adjust to light/dark theme
 */
exports._setDarkMode = _setDarkMode;
const euiThemeVars = exports.euiThemeVars = new Proxy(isDarkMode ? euiDarkVars : euiLightVars, {
  get(accessedTarget, accessedKey, ...rest) {
    return Reflect.get(isDarkMode ? euiDarkVars : euiLightVars, accessedKey, ...rest);
  }
});