"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiActionsExecutionService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _context_menu = require("../context_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class UiActionsExecutionService {
  constructor() {
    (0, _defineProperty2.default)(this, "batchingQueue", []);
    (0, _defineProperty2.default)(this, "pendingTasks", new Set());
  }
  async execute({
    action,
    context,
    trigger
  }, alwaysShowPopup) {
    var _await$action$shouldA, _action$shouldAutoExe;
    const shouldBatch = (_await$action$shouldA = !(await ((_action$shouldAutoExe = action.shouldAutoExecute) === null || _action$shouldAutoExe === void 0 ? void 0 : _action$shouldAutoExe.call(action, {
      ...context,
      trigger
    })))) !== null && _await$action$shouldA !== void 0 ? _await$action$shouldA : false;
    const task = {
      action,
      context,
      trigger,
      defer: (0, _public.defer)(),
      alwaysShowPopup: !!alwaysShowPopup
    };
    if (shouldBatch) {
      this.batchingQueue.push(task);
    } else {
      this.pendingTasks.add(task);
      try {
        await action.execute({
          ...context,
          trigger
        });
        this.pendingTasks.delete(task);
      } catch (e) {
        this.pendingTasks.delete(task);
        throw new Error(e);
      }
    }
    this.scheduleFlush();
    return task.defer.promise;
  }
  scheduleFlush() {
    /**
     * Have to delay at least until next macro task
     * Otherwise chain:
     * Trigger -> await action.execute() -> trigger -> action
     * isn't batched
     *
     * This basically needed to support a chain of scheduled micro tasks (async/awaits) within uiActions code
     */
    setTimeout(() => {
      if (this.pendingTasks.size === 0) {
        const tasks = (0, _lodash.uniqBy)(this.batchingQueue, t => t.action.id);
        if (tasks.length > 0) {
          let alwaysShowPopup = false;
          for (const task of tasks) {
            if (task.alwaysShowPopup) {
              alwaysShowPopup = true;
              break;
            }
          }
          if (alwaysShowPopup) {
            this.showActionPopupMenu(tasks);
          } else {
            if (tasks.length === 1) {
              this.executeSingleTask(tasks[0]);
            } else if (tasks.length > 1) {
              this.showActionPopupMenu(tasks);
            }
          }
        }
        this.batchingQueue.splice(0, this.batchingQueue.length);
      }
    }, 0);
  }
  async executeSingleTask({
    context,
    action,
    defer,
    trigger
  }) {
    try {
      await action.execute({
        ...context,
        trigger
      });
      defer.resolve();
    } catch (e) {
      defer.reject(e);
    }
  }
  async showActionPopupMenu(tasks) {
    const panels = await (0, _context_menu.buildContextMenuForActions)({
      actions: tasks.map(({
        action,
        context,
        trigger
      }) => ({
        action,
        context,
        trigger
      })),
      title: '',
      // Empty title is set intentionally.
      closeMenu: () => {
        tasks.forEach(t => t.defer.resolve());
        session.close();
      }
    });
    const session = (0, _context_menu.openContextMenu)(panels, {
      'data-test-subj': 'multipleActionsContextMenu'
    });
  }
}
exports.UiActionsExecutionService = UiActionsExecutionService;