"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transitions = exports.selectors = exports.defaultState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This interface represents the state of @type {DynamicActionManager} at every
 * point in time.
 */

const defaultState = exports.defaultState = {
  isFetchingEvents: false,
  fetchCount: 0,
  events: []
};
const transitions = exports.transitions = {
  startFetching: state => () => ({
    ...state,
    isFetchingEvents: true
  }),
  finishFetching: state => events => ({
    ...state,
    isFetchingEvents: false,
    fetchCount: state.fetchCount + 1,
    fetchError: undefined,
    events
  }),
  failFetching: state => ({
    message
  }) => ({
    ...state,
    isFetchingEvents: false,
    fetchCount: state.fetchCount + 1,
    fetchError: {
      message
    }
  }),
  addEvent: state => event => ({
    ...state,
    events: [...state.events, event]
  }),
  removeEvent: state => eventId => ({
    ...state,
    events: state.events ? state.events.filter(event => event.eventId !== eventId) : state.events
  }),
  replaceEvent: state => event => {
    const index = state.events.findIndex(({
      eventId
    }) => eventId === event.eventId);
    if (index === -1) return state;
    return {
      ...state,
      events: [...state.events.slice(0, index), event, ...state.events.slice(index + 1)]
    };
  }
};
const selectors = exports.selectors = {
  getEvent: state => eventId => state.events.find(event => event.eventId === eventId) || null
};