"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_SUBJ_SELECTED_ACTION_FACTORY = exports.TEST_SUBJ_ACTION_FACTORY_ITEM = exports.ActionWizard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("./i18n");
require("./action_wizard.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ActionWizard = ({
  currentActionFactory,
  actionFactories,
  onActionFactoryChange,
  onConfigChange,
  config,
  context,
  onSelectedTriggersChange,
  getTriggerInfo,
  triggers,
  triggerPickerDocsLink
}) => {
  var _context$triggers2;
  // auto pick action factory if there is only 1 available
  _react.default.useEffect(() => {
    if (!currentActionFactory && actionFactories.length === 1 && actionFactories[0].isCompatibleLicense()) {
      onActionFactoryChange(actionFactories[0]);
    }
  }, [currentActionFactory, actionFactories, actionFactories.length, onActionFactoryChange]);

  // auto pick selected trigger if none is picked
  _react.default.useEffect(() => {
    var _context$triggers$len, _context$triggers;
    if (currentActionFactory && !(((_context$triggers$len = (_context$triggers = context.triggers) === null || _context$triggers === void 0 ? void 0 : _context$triggers.length) !== null && _context$triggers$len !== void 0 ? _context$triggers$len : 0) > 0)) {
      const actionTriggers = getTriggersForActionFactory(currentActionFactory, triggers);
      if (actionTriggers.length > 0) {
        onSelectedTriggersChange([actionTriggers[0]]);
      }
    }
  }, [currentActionFactory, triggers, (_context$triggers2 = context.triggers) === null || _context$triggers2 === void 0 ? void 0 : _context$triggers2.length, onSelectedTriggersChange]);
  if (currentActionFactory) {
    if (!config) return null;
    const allTriggers = getTriggersForActionFactory(currentActionFactory, triggers);
    return /*#__PURE__*/_react.default.createElement(SelectedActionFactory, {
      actionFactory: currentActionFactory,
      showDeselect: actionFactories.length > 1,
      onDeselect: () => {
        onActionFactoryChange(undefined);
      },
      context: context,
      config: config,
      onConfigChange: newConfig => {
        onConfigChange(newConfig);
      },
      allTriggers: allTriggers,
      getTriggerInfo: getTriggerInfo,
      onSelectedTriggersChange: onSelectedTriggersChange,
      triggerPickerDocsLink: triggerPickerDocsLink
    });
  }
  return /*#__PURE__*/_react.default.createElement(ActionFactorySelector, {
    context: context,
    actionFactories: actionFactories,
    onActionFactorySelected: onActionFactoryChange
  });
};
exports.ActionWizard = ActionWizard;
const TriggerPicker = ({
  triggers,
  selectedTriggers,
  getTriggerInfo,
  onSelectedTriggersChange,
  triggerPickerDocsLink
}) => {
  const selectedTrigger = selectedTriggers ? selectedTriggers[0] : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    "data-test-subj": `triggerPicker`,
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.txtTriggerPickerLabel), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.txtTriggerPickerHelpTooltip
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: triggerPickerDocsLink,
        target: 'blank',
        external: true
      }, _i18n.txtTriggerPickerHelpText))))
    },
    style: {
      maxWidth: `80%`
    }
  }, triggers.map(trigger => {
    var _getTriggerInfo$title, _getTriggerInfo, _getTriggerInfo2, _getTriggerInfo3;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: trigger
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
      id: trigger,
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xxs'
      }, /*#__PURE__*/_react.default.createElement("span", null, (_getTriggerInfo$title = (_getTriggerInfo = getTriggerInfo(trigger)) === null || _getTriggerInfo === void 0 ? void 0 : _getTriggerInfo.title) !== null && _getTriggerInfo$title !== void 0 ? _getTriggerInfo$title : 'Unknown')), ((_getTriggerInfo2 = getTriggerInfo(trigger)) === null || _getTriggerInfo2 === void 0 ? void 0 : _getTriggerInfo2.description) && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: 's'
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: 'subdued'
      }, (_getTriggerInfo3 = getTriggerInfo(trigger)) === null || _getTriggerInfo3 === void 0 ? void 0 : _getTriggerInfo3.description)))),
      name: trigger,
      value: trigger,
      checked: selectedTrigger === trigger,
      onChange: () => onSelectedTriggersChange([trigger]),
      "data-test-subj": `triggerPicker-${trigger}`
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 's'
    }));
  }));
};
const TEST_SUBJ_SELECTED_ACTION_FACTORY = exports.TEST_SUBJ_SELECTED_ACTION_FACTORY = 'selectedActionFactory';
const SelectedActionFactory = ({
  actionFactory,
  onDeselect,
  showDeselect,
  onConfigChange,
  config,
  context,
  allTriggers,
  getTriggerInfo,
  onSelectedTriggersChange,
  triggerPickerDocsLink
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "auaActionWizard__selectedActionFactoryContainer",
    "data-test-subj": `${TEST_SUBJ_SELECTED_ACTION_FACTORY}-${actionFactory.id}`
  }, /*#__PURE__*/_react.default.createElement("header", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, actionFactory.getIconType(context) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: actionFactory.getIconType(context),
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, actionFactory.getDisplayName(context), ' ', actionFactory.isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.txtBetaActionFactoryLabel,
    tooltipContent: _i18n.txtBetaActionFactoryTooltip
  })))), showDeselect && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: () => onDeselect()
  }, _i18n.txtChangeButton)))), allTriggers.length > 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(TriggerPicker, {
    triggers: allTriggers,
    getTriggerInfo: getTriggerInfo,
    selectedTriggers: context.triggers,
    onSelectedTriggersChange: onSelectedTriggersChange,
    triggerPickerDocsLink: triggerPickerDocsLink
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(actionFactory.CollectConfig, {
    config: config,
    onConfig: onConfigChange,
    context: context
  })));
};
const TEST_SUBJ_ACTION_FACTORY_ITEM = exports.TEST_SUBJ_ACTION_FACTORY_ITEM = 'actionFactoryItem';
const ActionFactorySelector = ({
  actionFactories,
  onActionFactorySelected,
  context
}) => {
  if (actionFactories.length === 0) {
    // this is not user facing, as it would be impossible to get into this state
    // just leaving for dev purposes for troubleshooting
    return /*#__PURE__*/_react.default.createElement("div", null, "No action factories to pick from");
  }

  // The below style is applied to fix Firefox rendering bug.
  // See: https://github.com/elastic/kibana/pull/61219/#pullrequestreview-402903330
  const firefoxBugFix = {
    willChange: 'opacity'
  };

  /**
   * make sure not compatible factories are in the end
   */
  const ensureOrder = factories => {
    const compatibleLicense = factories.filter(f => f.isCompatibleLicense());
    const notCompatibleLicense = factories.filter(f => !f.isCompatibleLicense());
    return [...compatibleLicense.sort((f1, f2) => f2.order - f1.order), ...notCompatibleLicense.sort((f1, f2) => f2.order - f1.order)];
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    wrap: true,
    style: firefoxBugFix
  }, ensureOrder(actionFactories).map(actionFactory => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: actionFactory.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !actionFactory.isCompatibleLicense() && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Insufficient license level",
      id: "uiActionsEnhanced.components.actionWizard.insufficientLicenseLevelTooltip"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
    className: "auaActionWizard__actionFactoryItem",
    label: actionFactory.getDisplayName(context),
    "data-test-subj": `${TEST_SUBJ_ACTION_FACTORY_ITEM}-${actionFactory.id}`,
    onClick: () => onActionFactorySelected(actionFactory),
    disabled: !actionFactory.isCompatibleLicense(),
    betaBadgeLabel: actionFactory.isBeta ? _i18n.txtBetaActionFactoryLabel : undefined,
    betaBadgeTooltipContent: actionFactory.isBeta ? _i18n.txtBetaActionFactoryTooltip : undefined
  }, actionFactory.getIconType(context) && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: actionFactory.getIconType(context),
    size: "m"
  }))))));
};
function getTriggersForActionFactory(actionFactory, allTriggers) {
  return actionFactory.supportedTriggers().filter(trigger => allTriggers.includes(trigger));
}