"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleStatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statuses = ['enabled', 'disabled', 'snoozed'];
const getOptionDataTestSubj = status => `ruleStatusFilterOption-${status}`;
const RuleStatusFilter = props => {
  const {
    selectedStatuses = [],
    dataTestSubj = 'ruleStatusFilter',
    selectDataTestSubj = 'ruleStatusFilterSelect',
    buttonDataTestSubj = 'ruleStatusFilterButton',
    optionDataTestSubj = getOptionDataTestSubj,
    onChange = () => {}
  } = props;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onFilterItemClick = (0, _react.useCallback)(newOption => () => {
    if (selectedStatuses.includes(newOption)) {
      onChange(selectedStatuses.filter(option => option !== newOption));
      return;
    }
    onChange([...selectedStatuses, newOption]);
  }, [selectedStatuses, onChange]);
  const onClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsOpen => !prevIsOpen);
  }, [setIsPopoverOpen]);
  const renderRuleStateOptions = status => {
    if (status === 'enabled') {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.ruleDetails.ruleStateFilter.enabledOptionText",
        defaultMessage: "Rule is enabled"
      });
    } else if (status === 'disabled') {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.ruleDetails.ruleStateFilter.disabledOptionText",
        defaultMessage: "Rule is disabled"
      });
    } else if (status === 'snoozed') {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.ruleDetails.ruleStateFilter.snoozedOptionText",
        defaultMessage: "Rule has snoozed"
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": buttonDataTestSubj,
      iconType: "arrowDown",
      hasActiveFilters: selectedStatuses.length > 0,
      numActiveFilters: selectedStatuses.length,
      numFilters: selectedStatuses.length,
      onClick: onClick
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleDetails.ruleStateFilterButton",
      defaultMessage: "Rule state"
    }))
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": selectDataTestSubj
  }, statuses.map(status => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableListItem, {
      key: status,
      "data-test-subj": optionDataTestSubj(status),
      onClick: onFilterItemClick(status),
      checked: selectedStatuses.includes(status) ? 'on' : undefined
    }, renderRuleStateOptions(status));
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleStatusFilter = RuleStatusFilter;