"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecurrenceScheduler = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _number_field = require("../helpers/number_field");
var _types = require("../../../../../../types");
var _i18n_month_day_date = require("../../../../../lib/i18n_month_day_date");
var _constants = require("./constants");
var _custom_recurrence_scheduler = require("./custom_recurrence_scheduler");
var _helpers = require("./helpers");
var _translations = require("./translations");
require("./recurrence_scheduler.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RecurrenceScheduler = ({
  startDate,
  endDate,
  onChange,
  initialState
}) => {
  const hasInitialized = (0, _react.useRef)(false);
  const [frequency, setFrequency] = (0, _react.useState)(_types.RRuleFrequency.DAILY);
  const [recurrenceEnds, setRecurrenceEnds] = (0, _react.useState)('never');
  const [customFrequency, setCustomFrequency] = (0, _react.useState)({
    freq: _types.RRuleFrequency.WEEKLY,
    interval: 1,
    byweekday: [],
    bymonthday: [],
    bymonth: []
  });
  const [recurrenceEndDate, setRecurrenceEndDate] = (0, _react.useState)(endDate);
  const [occurrences, setOccurrrences] = (0, _react.useState)(1);
  const snoozeDurationInDays = (0, _react.useMemo)(() => {
    if (!startDate || !endDate) return 0;
    return Math.abs(startDate.diff(endDate, 'days'));
  }, [startDate, endDate]);
  const disableDailyOption = (0, _react.useMemo)(() => {
    return snoozeDurationInDays > 0;
  }, [snoozeDurationInDays]);
  (0, _react.useEffect)(() => {
    if (disableDailyOption && frequency === _types.RRuleFrequency.DAILY) {
      setFrequency(_types.RRuleFrequency.WEEKLY);
    }
  }, [disableDailyOption, frequency]);
  (0, _react.useEffect)(() => {
    if (initialState && !hasInitialized.current) {
      var _initialState$byweekd;
      const isCustomFrequency = initialState.interval > 1 || ((_initialState$byweekd = initialState.byweekday) !== null && _initialState$byweekd !== void 0 ? _initialState$byweekd : []).length > 1;
      setFrequency(isCustomFrequency ? 'CUSTOM' : initialState.freq);
      if (isCustomFrequency) {
        setCustomFrequency(initialState);
      }
      if (initialState.until) {
        setRecurrenceEnds('ondate');
        setRecurrenceEndDate(initialState.until);
      }
      if (initialState.count) {
        setRecurrenceEnds('afterx');
        setOccurrrences(initialState.count);
      }
    }
    hasInitialized.current = true;
  }, [initialState]);
  const {
    repeatOptions,
    rrulePresets
  } = (0, _react.useMemo)(() => {
    if (!startDate) {
      return {
        repeatOptions: _constants.DEFAULT_REPEAT_OPTIONS,
        rrulePresets: _constants.DEFAULT_RRULE_PRESETS
      };
    }
    const {
      dayOfWeek,
      nthWeekdayOfMonth,
      isLastOfMonth
    } = (0, _helpers.getWeekdayInfo)(startDate);
    return {
      repeatOptions: [{
        text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurDaily', {
          defaultMessage: 'Daily'
        }),
        value: _types.RRuleFrequency.DAILY,
        disabled: disableDailyOption
      }, {
        text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurWeeklyOnWeekday', {
          defaultMessage: 'Weekly on {dayOfWeek}',
          values: {
            dayOfWeek
          }
        }),
        value: _types.RRuleFrequency.WEEKLY
      }, {
        text: (0, _translations.i18nNthWeekday)(dayOfWeek)[isLastOfMonth ? 0 : nthWeekdayOfMonth],
        value: _types.RRuleFrequency.MONTHLY
      }, {
        text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurYearlyOnDay', {
          defaultMessage: 'Yearly on {date}',
          values: {
            date: (0, _i18n_month_day_date.i18nMonthDayDate)(startDate)
          }
        }),
        value: _types.RRuleFrequency.YEARLY
      }, {
        text: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.recurCustom', {
          defaultMessage: 'Custom'
        }),
        value: 'CUSTOM'
      }],
      rrulePresets: {
        [_types.RRuleFrequency.DAILY]: {
          interval: 1
        },
        [_types.RRuleFrequency.WEEKLY]: {
          interval: 1,
          byweekday: [_constants.ISO_WEEKDAYS_TO_RRULE[startDate.isoWeekday()]]
        },
        [_types.RRuleFrequency.MONTHLY]: {
          interval: 1,
          byweekday: (0, _helpers.generateNthByweekday)(startDate)
        },
        [_types.RRuleFrequency.YEARLY]: {
          interval: 1,
          bymonth: [startDate.month() + 1],
          bymonthday: [startDate.date()]
        }
      }
    };
  }, [startDate, disableDailyOption]);
  const compiledRecurrenceSchedule = (0, _react.useMemo)(() => {
    const recurrenceEndProps = recurrenceEnds === 'ondate' && recurrenceEndDate ? {
      until: recurrenceEndDate
    } : recurrenceEnds === 'afterx' ? {
      count: occurrences
    } : {};
    if (frequency === 'CUSTOM') {
      return {
        ...rewriteCustomFrequency(customFrequency),
        ...recurrenceEndProps
      };
    }
    return {
      freq: frequency,
      ...rrulePresets[frequency],
      ...recurrenceEndProps
    };
  }, [frequency, rrulePresets, recurrenceEnds, customFrequency, recurrenceEndDate, occurrences]);
  (0, _react.useEffect)(() => {
    onChange(compiledRecurrenceSchedule);
  }, [compiledRecurrenceSchedule, onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    className: "ramRecurrenceScheduler"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    style: {
      alignItems: 'center'
    },
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.repeatLabel', {
      defaultMessage: 'Repeat'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: repeatOptions,
    value: frequency,
    onChange: e => setFrequency(e.target.value === 'CUSTOM' ? 'CUSTOM' : Number(e.target.value)),
    compressed: true
  })), frequency === 'CUSTOM' && /*#__PURE__*/_react.default.createElement(_custom_recurrence_scheduler.CustomRecurrenceScheduler, {
    startDate: startDate,
    onChange: setCustomFrequency,
    initialState: customFrequency,
    minimumRecurrenceDays: snoozeDurationInDays + 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    style: {
      alignItems: 'center'
    },
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.endsLabel', {
      defaultMessage: 'Ends'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    isFullWidth: true,
    type: "single",
    legend: "Recurrence ends",
    idSelected: recurrenceEnds,
    onChange: setRecurrenceEnds,
    options: _constants.RECURRENCE_END_OPTIONS
  })), recurrenceEnds === 'ondate' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    style: {
      alignItems: 'center'
    },
    label: " ",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    selected: recurrenceEndDate,
    onChange: setRecurrenceEndDate,
    minDate: startDate !== null && startDate !== void 0 ? startDate : (0, _moment.default)()
  })), recurrenceEnds === 'afterx' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    style: {
      alignItems: 'center'
    },
    label: " ",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    compressed: true,
    prepend: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.afterOccurrencesLabel', {
      defaultMessage: 'After'
    }),
    append: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.occurrencesLabel', {
      defaultMessage: '{occurrences, plural, one {occurrence} other {occurrences}}',
      values: {
        occurrences
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_number_field.NumberField, {
    compressed: true,
    min: 1,
    value: occurrences,
    onChange: value => setOccurrrences(Number(value))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    style: {
      maxWidth: '400px'
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.repeatsSummary', {
    defaultMessage: 'Repeats {summary}',
    values: {
      summary: (0, _helpers.recurrenceSummary)(compiledRecurrenceSchedule)
    }
  })));
};
exports.RecurrenceScheduler = RecurrenceScheduler;
const rewriteCustomFrequency = customFreq => {
  var _result$byweekday, _result$bymonth, _result$bymonthday;
  const result = {
    ...customFreq
  };
  if (((_result$byweekday = result.byweekday) === null || _result$byweekday === void 0 ? void 0 : _result$byweekday.length) === 0) delete result.byweekday;
  if (((_result$bymonth = result.bymonth) === null || _result$bymonth === void 0 ? void 0 : _result$bymonth.length) === 0) delete result.bymonth;
  if (((_result$bymonthday = result.bymonthday) === null || _result$bymonthday === void 0 ? void 0 : _result$bymonthday.length) === 0) delete result.bymonthday;
  return result;
};