"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomRecurrenceScheduler = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _number_field = require("../helpers/number_field");
var _types = require("../../../../../../types");
var _constants = require("./constants");
var _helpers = require("./helpers");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomRecurrenceScheduler = ({
  startDate,
  onChange,
  initialState,
  minimumRecurrenceDays
}) => {
  var _initialState$byweekd, _initialState$byweekd2;
  const [initialStartDate] = (0, _react.useState)(startDate);
  const [frequency, setFrequency] = (0, _react.useState)(initialState.freq);
  const [interval, setInterval] = (0, _react.useState)(initialState.freq === _types.RRuleFrequency.DAILY ? Math.max(minimumRecurrenceDays, initialState.interval) : initialState.interval);
  const [byweekday, setByweekday] = (0, _react.useState)((0, _helpers.getInitialByweekday)(initialState.byweekday, startDate));
  const [monthlyRecurDay, setMonthlyRecurDay] = (0, _react.useState)(initialState.freq === _types.RRuleFrequency.MONTHLY && ((_initialState$byweekd = (_initialState$byweekd2 = initialState.byweekday) === null || _initialState$byweekd2 === void 0 ? void 0 : _initialState$byweekd2.length) !== null && _initialState$byweekd !== void 0 ? _initialState$byweekd : 0) > 0 ? 'weekday' : 'day');
  const monthlyRecurDayOptions = (0, _react.useMemo)(() => {
    if (!startDate) return [];
    const {
      dayOfWeek,
      nthWeekdayOfMonth,
      isLastOfMonth
    } = (0, _helpers.getWeekdayInfo)(startDate, 'ddd');
    return [{
      id: 'day',
      label: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.repeatOnMonthlyDayNumber', {
        defaultMessage: 'On day {dayNumber}',
        values: {
          dayNumber: startDate.date()
        }
      })
    }, {
      id: 'weekday',
      label: (0, _translations.i18nNthWeekdayShort)(dayOfWeek)[isLastOfMonth ? 0 : nthWeekdayOfMonth]
    }];
  }, [startDate]);
  (0, _react.useEffect)(() => {
    if (frequency === _types.RRuleFrequency.DAILY && interval < minimumRecurrenceDays) {
      setInterval(minimumRecurrenceDays);
    }
  }, [minimumRecurrenceDays, frequency, interval, setInterval]);
  (0, _react.useEffect)(() => {
    if (initialStartDate !== startDate) setByweekday((0, _helpers.getInitialByweekday)([], startDate));
  }, [startDate, initialStartDate]);
  const customRecurrenceSchedulerState = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    const nextState = (0, _helpers.buildCustomRecurrenceSchedulerState)({
      frequency,
      interval,
      byweekday,
      monthlyRecurDay,
      startDate
    });
    if (!(0, _fastDeepEqual.default)(customRecurrenceSchedulerState.current, nextState)) {
      onChange(nextState);
      customRecurrenceSchedulerState.current = nextState;
    }
  }, [frequency, interval, byweekday, monthlyRecurDay, startDate, onChange]);
  const onToggleWeekday = (0, _react.useCallback)(id => {
    const newByweekday = {
      ...byweekday,
      [id]: !byweekday[id]
    };
    // Don't allow the user to deselect all weekdays
    if (!Object.values(newByweekday).every(v => v === false)) {
      setByweekday(newByweekday);
    }
  }, [byweekday]);
  const endControlOptions = (0, _react.useMemo)(() => (0, _translations.i18nEndControlOptions)(interval), [interval]);
  const intervalMin = (0, _react.useMemo)(() => {
    if (frequency !== _types.RRuleFrequency.DAILY) return 1;
    return Math.max(minimumRecurrenceDays, 1);
  }, [frequency, minimumRecurrenceDays]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    "data-test-subj": "customRecurrenceScheduler",
    fullWidth: true,
    label: " "
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    compressed: true,
    prepend: _i18n.i18n.translate('xpack.triggersActionsUI.ruleSnoozeScheduler.repeatIntervalLabel', {
      defaultMessage: 'Every'
    })
  }, /*#__PURE__*/_react.default.createElement(_number_field.NumberField, {
    compressed: true,
    "data-test-subj": "customRecurrenceSchedulerInterval",
    min: intervalMin,
    value: interval,
    onChange: value => setInterval(Number(value))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    className: "customRecurrenceSchedulerFrequency",
    "data-test-subj": "customRecurrenceSchedulerFrequency",
    onChange: e => setFrequency(Number(e.target.value)),
    value: frequency,
    options: endControlOptions
  })))), frequency === _types.RRuleFrequency.WEEKLY && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: ' ',
    "data-test-subj": "customRecurrenceSchedulerWeekly"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    isFullWidth: true,
    type: "multi",
    legend: "Repeat on weekday",
    idToSelectedMap: byweekday,
    onChange: onToggleWeekday,
    options: _constants.I18N_WEEKDAY_OPTIONS
  })), frequency === _types.RRuleFrequency.MONTHLY && startDate && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    "data-test-subj": "customRecurrenceSchedulerMonthly",
    label: " "
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    isFullWidth: true,
    type: "single",
    legend: "Repeat on weekday or month day",
    idSelected: monthlyRecurDay,
    onChange: setMonthlyRecurDay,
    options: monthlyRecurDayOptions
  })));
};
exports.CustomRecurrenceScheduler = CustomRecurrenceScheduler;