"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleExecutionStatusFilter = void 0;
Object.defineProperty(exports, "getHealthColor", {
  enumerable: true,
  get: function () {
    return _lib.getExecutionStatusHealthColor;
  }
});
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _translations = require("../translations");
var _lib = require("../../../../common/lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortedRuleExecutionStatusValues = [..._common.RuleExecutionStatusValues].sort();
const RuleExecutionStatusFilter = ({
  selectedStatuses,
  onChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selectedValues, setSelectedValues] = (0, _react.useState)(selectedStatuses);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onTogglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsPopoverOpen => !prevIsPopoverOpen);
  }, [setIsPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange(selectedValues);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedValues]);
  (0, _react.useEffect)(() => {
    setSelectedValues(selectedStatuses);
  }, [selectedStatuses]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      hasActiveFilters: selectedValues.length > 0,
      numActiveFilters: selectedValues.length,
      numFilters: selectedValues.length,
      onClick: onTogglePopover,
      "data-test-subj": "ruleExecutionStatusFilterButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.rulesList.ruleExecutionStatusFilterLabel",
      defaultMessage: "Last response"
    }))
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, sortedRuleExecutionStatusValues.map(item => {
    const healthColor = (0, _lib.getExecutionStatusHealthColor)(item);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: item,
      style: {
        textTransform: 'capitalize'
      },
      onClick: () => {
        const isPreviouslyChecked = selectedValues.includes(item);
        if (isPreviouslyChecked) {
          setSelectedValues(selectedValues.filter(val => val !== item));
        } else {
          setSelectedValues(selectedValues.concat(item));
        }
      },
      checked: selectedValues.includes(item) ? 'on' : undefined,
      "data-test-subj": `ruleExecutionStatus${item}FilterOption`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: healthColor
    }, _translations.rulesStatusesTranslationsMapping[item]));
  })));
};
exports.RuleExecutionStatusFilter = RuleExecutionStatusFilter;