"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListNotifyBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../common/lib/kibana");
var _i18n_month_day_date = require("../../../../lib/i18n_month_day_date");
var _rule_snooze = require("../rule_snooze");
var _helpers = require("./helpers");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTimeRemaining(endtime) {
  const duration = _moment.default.duration((0, _moment.default)(endtime).diff((0, _moment.default)()));
  const timeValues = {
    years: _translations.UNITS_TRANSLATION.getYearsTranslation(duration.years()),
    months: _translations.UNITS_TRANSLATION.getMonthsTranslation(duration.months()),
    weeks: _translations.UNITS_TRANSLATION.getWeeksTranslation(duration.weeks()),
    days: _translations.UNITS_TRANSLATION.getDaysTranslation(duration.days()),
    hours: _translations.UNITS_TRANSLATION.getHoursTranslation(duration.hours()),
    minutes: _translations.UNITS_TRANSLATION.getMinutesTranslation(duration.minutes()),
    seconds: _translations.UNITS_TRANSLATION.getSecondsTranslation(duration.seconds())
  };
  const timeComponents = Object.entries(timeValues).filter(([unit, value]) => value !== '' && value !== `0 ${unit}`).map(([unit, value]) => `${value}`).join(', ');
  const lastComponentIndex = timeComponents.lastIndexOf(', ');
  const formattedTime = lastComponentIndex === -1 ? timeComponents : timeComponents.slice(0, lastComponentIndex) + ' and' + timeComponents.slice(lastComponentIndex + 1);
  return formattedTime;
}
const RulesListNotifyBadge = ({
  snoozeSettings,
  loading = false,
  disabled = false,
  onRuleChanged,
  snoozeRule,
  unsnoozeRule,
  showOnHover = false,
  showTooltipInline = false
}) => {
  var _snoozeSettings$muteA, _snoozeSettings$snooz, _snoozeSettings$activ;
  const [requestInFlight, setRequestInFlightLoading] = (0, _react.useState)(false);
  const isLoading = loading || requestInFlight;
  const isDisabled = Boolean(disabled) || !snoozeSettings;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const openPopover = (0, _react.useCallback)(() => setIsPopoverOpen(true), [setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), [setIsPopoverOpen]);
  const isSnoozedUntil = snoozeSettings === null || snoozeSettings === void 0 ? void 0 : snoozeSettings.isSnoozedUntil;
  const muteAll = (_snoozeSettings$muteA = snoozeSettings === null || snoozeSettings === void 0 ? void 0 : snoozeSettings.muteAll) !== null && _snoozeSettings$muteA !== void 0 ? _snoozeSettings$muteA : false;
  const isSnoozedIndefinitely = muteAll;
  const isSnoozed = (0, _react.useMemo)(() => snoozeSettings ? (0, _helpers.isRuleSnoozed)(snoozeSettings) : false, [snoozeSettings]);
  const nextScheduledSnooze = (0, _react.useMemo)(() => snoozeSettings ? (0, _helpers.getNextRuleSnoozeSchedule)(snoozeSettings) : null, [snoozeSettings]);
  const snoozeTimeLeft = (0, _react.useMemo)(() => isSnoozedUntil ? getTimeRemaining(isSnoozedUntil) : undefined, [isSnoozedUntil]);
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const isScheduled = (0, _react.useMemo)(() => {
    return !isSnoozed && Boolean(nextScheduledSnooze);
  }, [nextScheduledSnooze, isSnoozed]);
  const formattedSnoozeText = (0, _react.useMemo)(() => {
    if (!isSnoozedUntil) {
      if (nextScheduledSnooze) return (0, _i18n_month_day_date.i18nAbbrMonthDayDate)((0, _moment.default)(nextScheduledSnooze.rRule.dtstart));
      return '';
    }
    return (0, _i18n_month_day_date.i18nAbbrMonthDayDate)((0, _moment.default)(isSnoozedUntil));
  }, [isSnoozedUntil, nextScheduledSnooze]);
  const snoozeTooltipText = (0, _react.useMemo)(() => {
    if (isSnoozedIndefinitely) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.snoozedIndefinitelyTooltip', {
        defaultMessage: 'Notifications snoozed indefinitely'
      });
    }
    if (isScheduled) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.snoozeScheduledTooltip', {
        defaultMessage: 'Notifications scheduled to snooze starting {schedStart}',
        values: {
          schedStart: (0, _i18n_month_day_date.i18nMonthDayDate)((0, _moment.default)(nextScheduledSnooze.rRule.dtstart))
        }
      });
    }
    if (isSnoozed && snoozeTimeLeft) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.timeRemaining', {
          defaultMessage: 'Time remaining'
        }),
        content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          direction: "column",
          gutterSize: "none"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement("span", null, snoozeTimeLeft)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement("span", null, isSnoozedUntil === null || isSnoozedUntil === void 0 ? void 0 : isSnoozedUntil.toString())))
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.snoozedTooltip', {
        defaultMessage: 'Notifications snoozing for {snoozeTime}',
        values: {
          snoozeTime: (0, _moment.default)(isSnoozedUntil).fromNow(true)
        }
      })));
    }
    if (showTooltipInline) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.noSnoozeAppliedTooltip', {
        defaultMessage: 'Notify when alerts generated'
      });
    }
    return '';
  }, [isSnoozedIndefinitely, isScheduled, isSnoozed, showTooltipInline, nextScheduledSnooze, snoozeTimeLeft, isSnoozedUntil]);
  const snoozedButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      isLoading: isLoading,
      disabled: isLoading || isDisabled,
      "data-test-subj": "rulesListNotifyBadge-snoozed",
      "aria-label": _translations.OPEN_SNOOZE_PANEL_ARIA_LABEL,
      minWidth: 85,
      iconType: "bellSlash",
      color: "accent",
      onClick: openPopover
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, formattedSnoozeText));
  }, [formattedSnoozeText, isLoading, isDisabled, openPopover]);
  const scheduledSnoozeButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      isLoading: isLoading,
      disabled: isLoading || isDisabled,
      "data-test-subj": "rulesListNotifyBadge-scheduled",
      minWidth: 85,
      iconType: "calendar",
      color: "text",
      "aria-label": _translations.OPEN_SNOOZE_PANEL_ARIA_LABEL,
      onClick: openPopover
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, formattedSnoozeText));
  }, [formattedSnoozeText, isLoading, isDisabled, openPopover]);
  const unsnoozedButton = (0, _react.useMemo)(() => {
    // This show on hover is needed because we need style sheets to achieve the
    // show on hover effect in the rules list. However we don't want this to be
    // a default behaviour of this component.
    const showOnHoverClass = showOnHover ? 'ruleSidebarItem__action' : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      isLoading: isLoading,
      disabled: isLoading || isDisabled,
      display: isLoading ? 'base' : 'empty',
      "data-test-subj": "rulesListNotifyBadge-unsnoozed",
      "aria-label": _translations.OPEN_SNOOZE_PANEL_ARIA_LABEL,
      className: isPopoverOpen || isLoading ? '' : showOnHoverClass,
      iconType: "bell",
      onClick: openPopover
    });
  }, [isPopoverOpen, isLoading, isDisabled, showOnHover, openPopover]);
  const indefiniteSnoozeButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      isLoading: isLoading,
      disabled: isLoading || isDisabled,
      display: "base",
      "data-test-subj": "rulesListNotifyBadge-snoozedIndefinitely",
      "aria-label": _translations.OPEN_SNOOZE_PANEL_ARIA_LABEL,
      iconType: "bellSlash",
      color: "accent",
      onClick: openPopover
    });
  }, [isLoading, isDisabled, openPopover]);
  const button = (0, _react.useMemo)(() => {
    if (isScheduled) {
      return scheduledSnoozeButton;
    }
    if (isSnoozedIndefinitely) {
      return indefiniteSnoozeButton;
    }
    if (isSnoozed) {
      return snoozedButton;
    }
    return unsnoozedButton;
  }, [isSnoozed, isScheduled, isSnoozedIndefinitely, scheduledSnoozeButton, snoozedButton, indefiniteSnoozeButton, unsnoozedButton]);
  const buttonWithToolTip = (0, _react.useMemo)(() => {
    const tooltipContent = typeof disabled === 'string' ? disabled : isPopoverOpen || showTooltipInline ? undefined : snoozeTimeLeft;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: tooltipContent ? _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.rulesListNotifyBadge.timeRemaining', {
        defaultMessage: 'Time remaining'
      }) : undefined,
      content: tooltipContent
    }, button);
  }, [disabled, isPopoverOpen, button, showTooltipInline, snoozeTimeLeft]);
  const onApplySnooze = (0, _react.useCallback)(async schedule => {
    try {
      setRequestInFlightLoading(true);
      closePopover();
      await snoozeRule(schedule);
      await onRuleChanged();
      toasts.addSuccess(_translations.SNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_translations.SNOOZE_FAILED_MESSAGE);
    } finally {
      setRequestInFlightLoading(false);
    }
  }, [setRequestInFlightLoading, snoozeRule, onRuleChanged, toasts, closePopover]);
  const onApplyUnsnooze = (0, _react.useCallback)(async scheduleIds => {
    try {
      setRequestInFlightLoading(true);
      closePopover();
      await unsnoozeRule(scheduleIds);
      await onRuleChanged();
      toasts.addSuccess(_translations.UNSNOOZE_SUCCESS_MESSAGE);
    } catch (e) {
      toasts.addDanger(_translations.SNOOZE_FAILED_MESSAGE);
    } finally {
      setRequestInFlightLoading(false);
    }
  }, [setRequestInFlightLoading, unsnoozeRule, onRuleChanged, toasts, closePopover]);
  const popover = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "rulesListNotifyBadge",
    isOpen: isPopoverOpen && !isDisabled,
    closePopover: closePopover,
    button: buttonWithToolTip,
    anchorPosition: "rightCenter",
    panelStyle: {
      maxHeight: '100vh',
      overflowY: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_snooze.SnoozePanel, {
    snoozeRule: onApplySnooze,
    unsnoozeRule: onApplyUnsnooze,
    interval: (0, _rule_snooze.futureTimeToInterval)(isSnoozedUntil),
    showCancel: isSnoozed,
    scheduledSnoozes: (_snoozeSettings$snooz = snoozeSettings === null || snoozeSettings === void 0 ? void 0 : snoozeSettings.snoozeSchedule) !== null && _snoozeSettings$snooz !== void 0 ? _snoozeSettings$snooz : [],
    activeSnoozes: (_snoozeSettings$activ = snoozeSettings === null || snoozeSettings === void 0 ? void 0 : snoozeSettings.activeSnoozes) !== null && _snoozeSettings$activ !== void 0 ? _snoozeSettings$activ : [],
    inPopover: true
  }));
  if (showTooltipInline) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, popover), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, snoozeTooltipText)));
  }
  return popover;
};
exports.RulesListNotifyBadge = RulesListNotifyBadge;