"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SolutionFilter = ({
  solutions,
  onChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selectedValues, setSelectedValues] = (0, _react.useState)([]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange(selectedValues);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedValues]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      iconType: "arrowDown",
      hasActiveFilters: selectedValues.length > 0,
      numActiveFilters: selectedValues.length,
      numFilters: selectedValues.length,
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "data-test-subj": "solutionsFilterButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleForm.solutionFilterLabel",
      defaultMessage: "Filter by use case"
    }))
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, [...solutions.entries()].map(([id, title]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    key: id,
    onClick: () => {
      const isPreviouslyChecked = selectedValues.includes(id);
      if (isPreviouslyChecked) {
        setSelectedValues(selectedValues.filter(val => val !== id));
      } else {
        setSelectedValues([...selectedValues, id]);
      }
    },
    checked: selectedValues.includes(id) ? 'on' : undefined,
    "data-test-subj": `solution${id}FilterOption`
  }, title)))));
};
exports.SolutionFilter = SolutionFilter;