"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowRequestModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _constants = require("../../constants");
var _create = require("../../lib/rule_api/create");
var _update = require("../../lib/rule_api/update");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stringify = (rule, edit) => {
  try {
    const request = edit ? (0, _update.rewriteBodyRequest)((0, _lodash.pick)(rule, _update.UPDATE_FIELDS)) : (0, _create.rewriteBodyRequest)(rule);
    return JSON.stringify(request, null, 2);
  } catch {
    return i18n.SHOW_REQUEST_MODAL_ERROR;
  }
};
const ShowRequestModal = ({
  onClose,
  rule,
  edit = false,
  ruleId
}) => {
  const formattedRequest = stringify(rule, edit);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": "showRequestModal",
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: "showRequestModal",
    "data-test-subj": "modalHeaderTitle"
  }, i18n.SHOW_REQUEST_MODAL_TITLE(edit))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "modalSubtitle"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, i18n.SHOW_REQUEST_MODAL_SUBTITLE(edit))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    "data-test-subj": "modalRequestCodeBlock"
  }, `${edit ? 'PUT' : 'POST'} kbn:${_constants.BASE_ALERTING_API_PATH}/rule${edit ? `/${ruleId}` : ''}\n${formattedRequest}`)));
};
exports.ShowRequestModal = ShowRequestModal;