"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleConditions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _common = require("@kbn/alerting-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUILT_IN_ACTION_GROUPS = new Set((0, _common.getBuiltinActionGroups)().map(({
  id
}) => id));
const RuleConditions = ({
  headline,
  actionGroups,
  onInitializeConditionsFor,
  onResetConditionsFor,
  includeBuiltInActionGroups = false,
  children
}) => {
  const [withConditions, withoutConditions] = (0, _lodash.partition)(includeBuiltInActionGroups ? actionGroups : actionGroups.filter(({
    id
  }) => !BUILT_IN_ACTION_GROUPS.has(id)), actionGroup => actionGroup.hasOwnProperty('conditions'));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h6", {
    className: "ruleConditions"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleForm.conditions.title",
    defaultMessage: "Conditions:"
  }))), headline && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "ruleConditionsHeadline"
  }, headline))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, withConditions.map(actionGroup => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `condition-${actionGroup.id}`
  }, /*#__PURE__*/_react.default.isValidElement(children) && /*#__PURE__*/_react.default.cloneElement(_react.default.Children.only(children), onResetConditionsFor ? {
    // @ts-expect-error upgrade typescript v4.9.5
    actionGroup,
    onResetConditionsFor
  } : {
    actionGroup
  }))), onInitializeConditionsFor && withoutConditions.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleForm.conditions.addConditionLabel",
    defaultMessage: "Add:"
  })), withoutConditions.map(actionGroup => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `condition-add-${actionGroup.id}`,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    onClick: () => onInitializeConditionsFor(actionGroup)
  }, actionGroup.name))))))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleConditions = RuleConditions;