"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleDefinition = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _use_load_rule_types_query = require("../../../hooks/use_load_rule_types_query");
var _kibana = require("../../../../common/lib/kibana");
var _capabilities = require("../../../lib/capabilities");
var _rule_actions = require("./rule_actions");
var _rule_form = require("../../rule_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleDefinition = ({
  rule,
  actionTypeRegistry,
  ruleTypeRegistry,
  onEditRule,
  hideEditButton = false,
  filteredRuleTypes = []
}) => {
  var _ruleTypeIndex$get;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const [editFlyoutVisible, setEditFlyoutVisible] = (0, _react.useState)(false);
  const [ruleType, setRuleType] = (0, _react.useState)();
  const {
    ruleTypesState: {
      data: ruleTypeIndex,
      isLoading: ruleTypesIsLoading
    }
  } = (0, _use_load_rule_types_query.useLoadRuleTypesQuery)({
    filteredRuleTypes
  });
  const ruleTypes = (0, _react.useMemo)(() => [...ruleTypeIndex.values()], [ruleTypeIndex]);
  const getRuleType = (0, _react.useMemo)(() => {
    if (ruleTypes.length && rule) {
      return ruleTypes.find(type => type.id === rule.ruleTypeId);
    }
  }, [rule, ruleTypes]);
  (0, _react.useEffect)(() => {
    setRuleType(getRuleType);
  }, [getRuleType]);
  const getRuleConditionsWording = () => {
    const numberOfConditions = rule !== null && rule !== void 0 && rule.params.criteria ? (rule === null || rule === void 0 ? void 0 : rule.params.criteria).length : 0;
    return _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.conditions', {
      defaultMessage: '{numberOfConditions, plural, one {# condition} other {# conditions}}',
      values: {
        numberOfConditions
      }
    });
  };
  const canReadActions = (0, _capabilities.hasShowActionsCapability)(capabilities);
  const canExecuteActions = (0, _capabilities.hasExecuteActionsCapability)(capabilities);
  const canSaveRule = rule && (0, _capabilities.hasAllPrivilege)(rule.consumer, ruleType) && (
  // if the rule has actions, can the user save the rule's action params
  canExecuteActions || !canExecuteActions && rule.actions.length === 0);
  const hasEditButton = (0, _react.useMemo)(() => {
    if (hideEditButton) {
      return false;
    }
    // can the user save the rule
    return canSaveRule && (
    // is this rule type editable from within Rules Management
    ruleTypeRegistry.has(rule.ruleTypeId) ? !ruleTypeRegistry.get(rule.ruleTypeId).requiresAppContext : false);
  }, [hideEditButton, canSaveRule, ruleTypeRegistry, rule]);
  const ruleDescription = (0, _react.useMemo)(() => {
    if (ruleTypeRegistry.has(rule.ruleTypeId)) {
      return ruleTypeRegistry.get(rule.ruleTypeId).description;
    }
    // TODO: Replace this generic description with proper SIEM rule descriptions
    if (rule.consumer === _ruleDataUtils.AlertConsumers.SIEM) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.securityDetectionRule', {
        defaultMessage: 'Security detection rule'
      });
    }
    return '';
  }, [rule, ruleTypeRegistry]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "ruleSummaryRuleDefinition",
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: false,
    paddingSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.definition', {
    defaultMessage: 'Definition'
  }))), ruleTypesIsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "ruleDetailsEditButtonLoadingSpinner"
  })) : hasEditButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "ruleDetailsEditButton",
    iconType: 'pencil',
    onClick: () => setEditFlyoutVisible(true)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(ItemTitleRuleSummary, null, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.ruleType', {
    defaultMessage: 'Rule type'
  })), ruleTypesIsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "ruleSummaryRuleTypeLoadingSpinner"
  })) : /*#__PURE__*/_react.default.createElement(ItemValueRuleSummary, {
    "data-test-subj": "ruleSummaryRuleType",
    itemValue: ((_ruleTypeIndex$get = ruleTypeIndex.get(rule.ruleTypeId)) === null || _ruleTypeIndex$get === void 0 ? void 0 : _ruleTypeIndex$get.name) || rule.ruleTypeId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(ItemTitleRuleSummary, null, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.description', {
    defaultMessage: 'Description'
  })), /*#__PURE__*/_react.default.createElement(ItemValueRuleSummary, {
    "data-test-subj": "ruleSummaryRuleDescription",
    itemValue: ruleDescription
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(ItemTitleRuleSummary, null, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.runsEvery', {
    defaultMessage: 'Runs every'
  })), /*#__PURE__*/_react.default.createElement(ItemValueRuleSummary, {
    "data-test-subj": "ruleSummaryRuleInterval",
    itemValue: (0, _common.formatDuration)(rule.schedule.interval)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(ItemTitleRuleSummary, null, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.conditionsTitle', {
    defaultMessage: 'Conditions'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "ruleSummaryRuleConditions",
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, hasEditButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setEditFlyoutVisible(true),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, getRuleConditionsWording())) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, getRuleConditionsWording()))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(ItemTitleRuleSummary, null, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.actions', {
    defaultMessage: 'Actions'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, canReadActions ? /*#__PURE__*/_react.default.createElement(_rule_actions.RuleActions, {
    ruleActions: rule.actions,
    actionTypeRegistry: actionTypeRegistry,
    legacyNotifyWhen: rule.notifyWhen
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.cannotReadActions', {
    defaultMessage: 'Connector feature privileges are required to view actions'
  })))))))), editFlyoutVisible && /*#__PURE__*/_react.default.createElement(_rule_form.RuleEdit, {
    onSave: () => {
      setEditFlyoutVisible(false);
      return onEditRule();
    },
    initialRule: rule,
    onClose: () => setEditFlyoutVisible(false),
    ruleTypeRegistry: ruleTypeRegistry,
    actionTypeRegistry: actionTypeRegistry
  }));
};
exports.default = exports.RuleDefinition = RuleDefinition;
function ItemValueRuleSummary({
  itemValue,
  extraSpace = true,
  ...otherProps
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, (0, _extends2.default)({
    grow: extraSpace ? 3 : 1
  }, otherProps), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, itemValue));
}
function ItemTitleRuleSummary({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      whiteSpace: 'nowrap'
    },
    grow: 1
  }, children));
}

// eslint-disable-next-line import/no-default-export