"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldBrowserModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _search = require("./components/search");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _categories_selector = require("./components/categories_selector");
var _categories_badges = require("./components/categories_badges");
var _field_table = require("./components/field_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component has no internal state, but it uses lifecycle methods to
 * set focus to the search input, scroll to the selected category, etc
 */
const FieldBrowserModalComponent = ({
  appliedFilterInput,
  columnIds,
  filteredBrowserFields,
  filterSelectedEnabled,
  isSearching,
  onFilterSelectedChange,
  onToggleColumn,
  onResetColumns,
  setSelectedCategoryIds,
  onSearchInputChange,
  onHide,
  options,
  restoreFocusTo,
  searchInput,
  selectedCategoryIds,
  width = _helpers.FIELD_BROWSER_WIDTH
}) => {
  const closeAndRestoreFocus = (0, _react.useCallback)(() => {
    onHide();
    setTimeout(() => {
      var _restoreFocusTo$curre;
      // restore focus on the next tick after we have escaped the EuiFocusTrap
      (_restoreFocusTo$curre = restoreFocusTo.current) === null || _restoreFocusTo$curre === void 0 ? void 0 : _restoreFocusTo$curre.focus();
    }, 0);
  }, [onHide, restoreFocusTo]);
  const resetColumns = (0, _react.useCallback)(() => {
    onResetColumns();
    closeAndRestoreFocus();
  }, [closeAndRestoreFocus, onResetColumns]);

  /** Invoked when the user types in the input to filter the field browser */
  const onInputChange = (0, _react.useCallback)(event => {
    onSearchInputChange(event.target.value);
  }, [onSearchInputChange]);
  const [CreateFieldButton, getFieldTableColumns] = [options === null || options === void 0 ? void 0 : options.createFieldButton, options === null || options === void 0 ? void 0 : options.getFieldTableColumns];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeAndRestoreFocus,
    style: {
      width,
      maxWidth: width
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "fields-browser-container",
    className: "eui-yScroll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.FIELDS_BROWSER)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search.Search, {
    "data-test-subj": "header",
    isSearching: isSearching,
    onSearchInputChange: onInputChange,
    searchInput: searchInput
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_categories_selector.CategoriesSelector, {
    filteredBrowserFields: filteredBrowserFields,
    setSelectedCategoryIds: setSelectedCategoryIds,
    selectedCategoryIds: selectedCategoryIds
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, CreateFieldButton && /*#__PURE__*/_react.default.createElement(CreateFieldButton, {
    onHide: onHide
  }))), /*#__PURE__*/_react.default.createElement(_categories_badges.CategoriesBadges, {
    selectedCategoryIds: selectedCategoryIds,
    setSelectedCategoryIds: setSelectedCategoryIds
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_field_table.FieldTable, {
    columnIds: columnIds,
    filteredBrowserFields: filteredBrowserFields,
    filterSelectedEnabled: filterSelectedEnabled,
    searchInput: appliedFilterInput,
    selectedCategoryIds: selectedCategoryIds,
    onFilterSelectedChange: onFilterSelectedChange,
    onToggleColumn: onToggleColumn,
    getFieldTableColumns: getFieldTableColumns,
    onHide: onHide
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: _helpers.RESET_FIELDS_CLASS_NAME,
    "data-test-subj": "reset-fields",
    onClick: resetColumns
  }, i18n.RESET_FIELDS)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: closeAndRestoreFocus,
    "aria-label": i18n.CLOSE,
    className: _helpers.CLOSE_BUTTON_CLASS_NAME,
    "data-test-subj": "close"
  }, i18n.CLOSE)))));
};
const FieldBrowserModal = exports.FieldBrowserModal = /*#__PURE__*/_react.default.memo(FieldBrowserModalComponent);