"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _field_items = require("../field_items");
var _helpers = require("../../helpers");
var _field_table_header = require("./field_table_header");
var _field_table = require("./field_table.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SORTING = {
  field: '',
  direction: 'asc'
};
const FieldTableComponent = ({
  columnIds,
  filteredBrowserFields,
  filterSelectedEnabled,
  getFieldTableColumns,
  onFilterSelectedChange,
  onHide,
  onToggleColumn,
  searchInput,
  selectedCategoryIds
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(DEFAULT_SORTING.field);
  const [sortDirection, setSortDirection] = (0, _react.useState)(DEFAULT_SORTING.direction);
  const {
    fieldItems
  } = (0, _react.useMemo)(() => (0, _field_items.getFieldItemsData)({
    browserFields: filteredBrowserFields,
    selectedCategoryIds,
    columnIds
  }), [columnIds, filteredBrowserFields, selectedCategoryIds]);

  /**
   * Pagination controls
   */
  const pagination = (0, _react.useMemo)(() => ({
    pageIndex,
    pageSize,
    totalItemCount: fieldItems.length,
    pageSizeOptions: [10, 25, 50]
  }), [fieldItems.length, pageIndex, pageSize]);
  (0, _react.useEffect)(() => {
    // Resets the pagination when some filter has changed, consequently, the number of fields is different
    setPageIndex(0);
  }, [fieldItems.length]);

  /**
   * Sorting controls
   */
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: sortField,
      direction: sortDirection
    }
  }), [sortDirection, sortField]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort = DEFAULT_SORTING
  }) => {
    const {
      index,
      size
    } = page;
    const {
      field,
      direction
    } = sort;
    setPageIndex(index);
    setPageSize(size);
    setSortField(field);
    setSortDirection(direction);
  }, []);

  /**
   * Process columns
   */
  const columns = (0, _react.useMemo)(() => (0, _field_items.getFieldColumns)({
    getFieldTableColumns,
    highlight: searchInput,
    onHide,
    onToggleColumn
  }), [getFieldTableColumns, searchInput, onHide, onToggleColumn]);
  const hasActions = (0, _react.useMemo)(() => columns.some(column => (0, _field_items.isActionsColumn)(column)), [columns]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_table_header.FieldTableHeader, {
    fieldCount: fieldItems.length,
    filterSelectedEnabled: filterSelectedEnabled,
    onFilterSelectedChange: onFilterSelectedChange
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: _field_table.styles.tableContainer({
      height: _helpers.TABLE_HEIGHT,
      euiTheme
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "field-table",
    className: `${_helpers.CATEGORY_TABLE_CLASS_NAME} eui-yScroll`,
    items: fieldItems,
    itemId: "name",
    columns: columns,
    pagination: pagination,
    sorting: sorting,
    hasActions: hasActions,
    onChange: onTableChange,
    compressed: true
  })));
};
const FieldTable = exports.FieldTable = /*#__PURE__*/_react.default.memo(FieldTableComponent);