"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectButtonContainer = exports.InspectButton = exports.BUTTON_CLASS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _hover_visibility_container = require("./hover_visibility_container");
var _modal = require("./modal");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUTTON_CLASS = exports.BUTTON_CLASS = 'inspectButtonComponent';
const VISIBILITY_CLASSES = [BUTTON_CLASS];
const InspectButtonContainer = exports.InspectButtonContainer = /*#__PURE__*/(0, _react.memo)(({
  children,
  hide
}) => /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
  hide: hide,
  targetClassNames: VISIBILITY_CLASSES
}, children));
const InspectButtonComponent = ({
  getInspectQuery,
  inspectTitle
}) => {
  const [isShowingModal, setIsShowingModal] = (0, _react.useState)(false);
  const onOpenModal = (0, _react.useCallback)(() => {
    setIsShowingModal(true);
  }, []);
  const onCloseModal = (0, _react.useCallback)(() => {
    setIsShowingModal(false);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: BUTTON_CLASS,
    "aria-label": i18n.INSPECT,
    "data-test-subj": "inspect-icon-button",
    iconSize: "m",
    iconType: "inspect",
    title: i18n.INSPECT,
    onClick: onOpenModal
  }), isShowingModal && /*#__PURE__*/_react.default.createElement(_modal.ModalInspectQuery, {
    closeModal: onCloseModal,
    "data-test-subj": "inspect-modal",
    getInspectQuery: getInspectQuery,
    title: inspectTitle
  }));
};
InspectButtonComponent.displayName = 'InspectButtonComponent';
const InspectButton = exports.InspectButton = /*#__PURE__*/_react.default.memo(InspectButtonComponent);