"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverVisibilityContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledDiv = _common.euiStyled.div`
  width: 100%;
  display: flex;
  flex-grow: 1;

  > * {
    max-width: 100%;
  }

  ${({
  targetClassNames,
  theme
}) => {
  return `
      ${targetClassNames.map(cn => `.${cn}`).join(', ')} {
        pointer-events: none;
        opacity: 0;
        transition: opacity ${(0, _fp.getOr)(250, 'eui.euiAnimSpeedNormal', theme)} ease;
      }

      ${targetClassNames.map(cn => `&:hover .${cn}`).join(', ')} {
        pointer-events: auto;
        opacity: 1;
      }
    `;
}}
`;
const HoverVisibilityContainer = exports.HoverVisibilityContainer = /*#__PURE__*/_react.default.memo(({
  hide,
  targetClassNames,
  children
}) => {
  if (hide) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  return /*#__PURE__*/_react.default.createElement(StyledDiv, {
    "data-test-subj": "hoverVisibilityContainer",
    targetClassNames: targetClassNames
  }, children);
});
HoverVisibilityContainer.displayName = 'HoverVisibilityContainer';