"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewRuleDetailsAlertAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MenuItem = (0, _styled.default)(_eui.EuiContextMenuItem)`
  &:hover {
    text-decoration: underline;
  }
`;

/**
 * Alerts table row action to open the rule to which the selected alert is associated
 */
const ViewRuleDetailsAlertAction = exports.ViewRuleDetailsAlertAction = /*#__PURE__*/(0, _react.memo)(({
  alert,
  resolveRulePagePath,
  id: pageId
}) => {
  var _alert$ALERT_RULE_UUI, _alert$ALERT_RULE_UUI2;
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana.useKibana)().services;
  const ruleId = (_alert$ALERT_RULE_UUI = (_alert$ALERT_RULE_UUI2 = alert[_ruleDataUtils.ALERT_RULE_UUID]) === null || _alert$ALERT_RULE_UUI2 === void 0 ? void 0 : _alert$ALERT_RULE_UUI2[0]) !== null && _alert$ALERT_RULE_UUI !== void 0 ? _alert$ALERT_RULE_UUI : null;
  const pagePath = ruleId && pageId && (resolveRulePagePath === null || resolveRulePagePath === void 0 ? void 0 : resolveRulePagePath(ruleId, pageId));
  const linkToRule = pagePath ? prepend(pagePath) : null;
  if (!linkToRule) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(MenuItem, {
    "data-test-subj": "viewRuleDetails",
    key: "viewRuleDetails",
    href: linkToRule,
    size: "s"
  }, _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.viewRuleDetails', {
    defaultMessage: 'View rule details'
  }));
});