"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewAlertDetailsAlertAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Alerts table row action to open the selected alert detail page
 */
const ViewAlertDetailsAlertAction = exports.ViewAlertDetailsAlertAction = /*#__PURE__*/(0, _react.memo)(({
  alert,
  setFlyoutAlert,
  onActionExecuted,
  isAlertDetailsEnabled,
  resolveAlertPagePath,
  id: pageId
}) => {
  var _alert$ALERT_UUID$, _alert$ALERT_UUID;
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana.useKibana)().services;
  const alertId = (_alert$ALERT_UUID$ = (_alert$ALERT_UUID = alert[_ruleDataUtils.ALERT_UUID]) === null || _alert$ALERT_UUID === void 0 ? void 0 : _alert$ALERT_UUID[0]) !== null && _alert$ALERT_UUID$ !== void 0 ? _alert$ALERT_UUID$ : null;
  const pagePath = alertId && pageId && (resolveAlertPagePath === null || resolveAlertPagePath === void 0 ? void 0 : resolveAlertPagePath(alertId, pageId));
  const linkToAlert = pagePath ? prepend(pagePath) : null;
  if (isAlertDetailsEnabled && linkToAlert) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "viewAlertDetailsPage",
      key: "viewAlertDetailsPage",
      size: "s",
      href: linkToAlert
    }, _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.viewAlertDetails', {
      defaultMessage: 'View alert details'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "viewAlertDetailsFlyout",
    key: "viewAlertDetailsFlyout",
    size: "s",
    onClick: () => {
      onActionExecuted === null || onActionExecuted === void 0 ? void 0 : onActionExecuted();
      setFlyoutAlert(alert._id);
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.viewAlertDetails', {
    defaultMessage: 'View alert details'
  }));
});