"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MuteAlertAction = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_mute_alert = require("../hooks/alert_mute/use_mute_alert");
var _translations = require("../hooks/translations");
var _use_unmute_alert = require("../hooks/alert_mute/use_unmute_alert");
var _use_alert_muted_state = require("../hooks/alert_mute/use_alert_muted_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Alerts table row action to mute/unmute the selected alert
 */
const MuteAlertAction = exports.MuteAlertAction = /*#__PURE__*/(0, _react.memo)(({
  alert,
  refresh,
  onActionExecuted
}) => {
  const {
    isMuted,
    ruleId,
    rule,
    alertInstanceId
  } = (0, _use_alert_muted_state.useAlertMutedState)(alert);
  const {
    mutateAsync: muteAlert
  } = (0, _use_mute_alert.useMuteAlert)();
  const {
    mutateAsync: unmuteAlert
  } = (0, _use_unmute_alert.useUnmuteAlert)();
  const isAlertActive = (0, _react.useMemo)(() => {
    var _alert$ALERT_STATUS;
    return ((_alert$ALERT_STATUS = alert[_ruleDataUtils.ALERT_STATUS]) === null || _alert$ALERT_STATUS === void 0 ? void 0 : _alert$ALERT_STATUS[0]) === _ruleDataUtils.ALERT_STATUS_ACTIVE;
  }, [alert]);
  const toggleAlert = (0, _react.useCallback)(async () => {
    if (ruleId == null || alertInstanceId == null) {
      return;
    }
    if (isMuted) {
      await unmuteAlert({
        ruleId,
        alertInstanceId
      });
    } else {
      await muteAlert({
        ruleId,
        alertInstanceId
      });
    }
    onActionExecuted === null || onActionExecuted === void 0 ? void 0 : onActionExecuted();
    refresh();
  }, [alertInstanceId, isMuted, muteAlert, onActionExecuted, refresh, ruleId, unmuteAlert]);
  if (!isAlertActive && !isMuted || ruleId == null || alertInstanceId == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "toggle-alert",
    onClick: toggleAlert,
    size: "s",
    disabled: !rule
  }, !rule ? _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.loadingMutedState', {
    defaultMessage: 'Loading muted state'
  }) : isMuted ? _translations.UNMUTE : _translations.MUTE);
});