"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchBrowserFieldCapabilities = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/rule-registry-plugin/common");
var _react = require("react");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVALID_FEATURE_ID = 'siem';
const useFetchBrowserFieldCapabilities = ({
  featureIds,
  initialBrowserFields
}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [isLoading, setIsLoading] = (0, _react.useState)(undefined);
  const [browserFields, setBrowserFields] = (0, _react.useState)(() => initialBrowserFields !== null && initialBrowserFields !== void 0 ? initialBrowserFields : {});
  const [fields, setFields] = (0, _react.useState)([]);
  const getBrowserFieldInfo = (0, _react.useCallback)(async validFeatureId => {
    if (!http) return Promise.resolve({
      browserFields: {},
      fields: []
    });
    try {
      return await http.get(`${_common.BASE_RAC_ALERTS_API_PATH}/browser_fields`, {
        query: {
          featureIds: validFeatureId
        }
      });
    } catch (e) {
      toasts.addDanger(_translations.ERROR_FETCH_BROWSER_FIELDS);
      return Promise.resolve({
        browserFields: {},
        fields: []
      });
    }
  }, [http, toasts]);
  (0, _react.useEffect)(() => {
    if (initialBrowserFields) {
      // Event if initial browser fields is empty, assign it
      // because client may be doing it to hide Fields Browser
      setBrowserFields(initialBrowserFields);
      return;
    }
    const validFeatureIdTmp = featureIds.filter(fid => (0, _ruleDataUtils.isValidFeatureId)(fid));
    if (isLoading !== undefined || featureIds.includes(INVALID_FEATURE_ID) || validFeatureIdTmp.length === 0) {
      return;
    }
    setIsLoading(true);
    const callApi = async validFeatureId => {
      const {
        browserFields: browserFieldsInfo,
        fields: newFields
      } = await getBrowserFieldInfo(validFeatureId);
      setFields(newFields);
      setBrowserFields(browserFieldsInfo);
      setIsLoading(false);
    };
    callApi(validFeatureIdTmp);
  }, [getBrowserFieldInfo, isLoading, featureIds, initialBrowserFields]);
  return [isLoading, browserFields, fields];
};
exports.useFetchBrowserFieldCapabilities = useFetchBrowserFieldCapabilities;