"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMutedAlerts = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTERNAL_FIND_RULES_URL = '/internal/alerting/rules/_find';
const getMutedAlerts = async (http, params, signal) => {
  const filterNode = _esQuery.nodeBuilder.or(params.ids.map(id => _esQuery.nodeBuilder.is('alert.id', `alert:${id}`)));
  return http.post(INTERNAL_FIND_RULES_URL, {
    body: JSON.stringify({
      filter: JSON.stringify(filterNode),
      fields: ['id', 'mutedInstanceIds'],
      page: 1,
      per_page: params.ids.length
    }),
    signal
  });
};
exports.getMutedAlerts = getMutedAlerts;