"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertMutedState = void 0;
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _ = require("../../../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertMutedState = alert => {
  var _alert$ALERT_INSTANCE, _alert$ALERT_RULE_UUI;
  const {
    mutedAlerts
  } = (0, _react.useContext)(_.AlertsTableContext);
  const alertInstanceId = alert && ((_alert$ALERT_INSTANCE = alert[_ruleDataUtils.ALERT_INSTANCE_ID]) === null || _alert$ALERT_INSTANCE === void 0 ? void 0 : _alert$ALERT_INSTANCE[0]);
  const ruleId = alert && ((_alert$ALERT_RULE_UUI = alert[_ruleDataUtils.ALERT_RULE_UUID]) === null || _alert$ALERT_RULE_UUI === void 0 ? void 0 : _alert$ALERT_RULE_UUI[0]);
  return (0, _react.useMemo)(() => {
    const rule = ruleId ? mutedAlerts[ruleId] : [];
    return {
      isMuted: alertInstanceId ? rule === null || rule === void 0 ? void 0 : rule.includes(alertInstanceId) : null,
      ruleId,
      rule,
      alertInstanceId
    };
  }, [alertInstanceId, mutedAlerts, ruleId]);
};
exports.useAlertMutedState = useAlertMutedState;