"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.systemCells = exports.SystemCellFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _default_cell = require("./default_cell");
var _alert_lifecycle_status_cell = require("./alert_lifecycle_status_cell");
var _cell = require("../cases/cell");
var _cell2 = require("../maintenance_windows/cell");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const systemCells = exports.systemCells = [_ruleDataUtils.ALERT_STATUS, _ruleDataUtils.ALERT_CASE_IDS, _ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS];
const SystemCellFactoryComponent = props => {
  const {
    columnId
  } = props;
  const cellComponents = (0, _react.useMemo)(() => ({
    [_ruleDataUtils.ALERT_STATUS]: _alert_lifecycle_status_cell.AlertLifecycleStatusCell,
    [_ruleDataUtils.ALERT_CASE_IDS]: _cell.CasesCell,
    [_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS]: _cell2.MaintenanceWindowCell
  }), []);
  if (cellComponents[columnId]) {
    const CellComponent = cellComponents[columnId];
    return /*#__PURE__*/_react.default.createElement(CellComponent, props);
  }
  return /*#__PURE__*/_react.default.createElement(_default_cell.DefaultCell, props);
};
SystemCellFactoryComponent.displayName = 'SystemCellFactory';
const SystemCellFactory = exports.SystemCellFactory = /*#__PURE__*/(0, _react.memo)(SystemCellFactoryComponent);