"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAlertFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutHeader = ({
  alert
}) => {
  const name = alert[_ruleDataUtils.ALERT_RULE_NAME];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, name));
};
const getDefaultAlertFlyout = (columns, formatter) => () => {
  const FlyoutBody = ({
    alert
  }) => {
    const overviewTab = (0, _react.useMemo)(() => ({
      id: 'overview',
      'data-test-subj': 'overviewTab',
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.alertsTable.alertsFlyout.overview', {
        defaultMessage: 'Overview'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasShadow: false,
        "data-test-subj": "overviewTabPanel"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        listItems: columns.map(column => {
          var _get;
          const value = (_get = (0, _lodash.get)(alert, column.id)) === null || _get === void 0 ? void 0 : _get[0];
          return {
            title: column.displayAsText,
            description: value != null ? formatter(column.id, value) : '—'
          };
        }),
        type: "column",
        columnWidths: [1, 3]
      }))
    }), [alert]);
    const tableTab = (0, _react.useMemo)(() => ({
      id: 'table',
      'data-test-subj': 'tableTab',
      name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.alertsTable.alertsFlyout.table', {
        defaultMessage: 'Table'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasShadow: false,
        "data-test-subj": "tableTabPanel"
      }, /*#__PURE__*/_react.default.createElement(_alertsUiShared.AlertFieldsTable, {
        alert: alert
      }))
    }), [alert]);
    const tabs = (0, _react.useMemo)(() => [overviewTab, tableTab], [overviewTab, tableTab]);
    const [selectedTabId, setSelectedTabId] = (0, _react.useState)('overview');
    const handleTabClick = (0, _react.useCallback)(tab => setSelectedTabId(tab.id), []);
    const selectedTab = (0, _react.useMemo)(() => {
      var _tabs$find;
      return (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
    }, [tabs, selectedTabId]);
    return /*#__PURE__*/_react.default.createElement(_alertsUiShared.ScrollableFlyoutTabbedContent, {
      tabs: tabs,
      selectedTab: selectedTab,
      onTabClick: handleTabClick,
      expand: true,
      "data-test-subj": "defaultAlertFlyoutTabs"
    });
  };
  return {
    header: FlyoutHeader,
    body: FlyoutBody,
    footer: null
  };
};
exports.getDefaultAlertFlyout = getDefaultAlertFlyout;