"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlSyncedAlertsSearchBar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _alert_filter_controls = require("@kbn/alerts-ui-shared/src/alert_filter_controls");
var _public = require("@kbn/controls-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _ = require("../../..");
var _use_alert_search_bar_state_container = require("./use_alert_search_bar_state_container");
var _constants = require("./constants");
var _alerts_search_bar = _interopRequireDefault(require("./alerts_search_bar"));
var _utils = require("../../../../common/utils");
var _build_es_query = require("./build_es_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVALID_QUERY_STRING_TOAST_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.urlSyncedAlertsSearchBar.invalidQueryTitle', {
  defaultMessage: 'Invalid query string'
});
/**
 * An abstraction over AlertsSearchBar that syncs the query state with the url
 */
const UrlSyncedAlertsSearchBar = ({
  showFilterControls = false,
  onEsQueryChange,
  onActiveFeatureFiltersChange,
  ...rest
}) => {
  const {
    http,
    data: {
      query: queryService
    },
    notifications,
    dataViews,
    spaces
  } = (0, _.useKibana)().services;
  const {
    toasts
  } = notifications;
  const {
    timefilter: {
      timefilter: timeFilterService
    }
  } = queryService;
  const [spaceId, setSpaceId] = (0, _react.useState)();
  const {
    kuery,
    onKueryChange,
    filters,
    onFiltersChange,
    controlFilters,
    onControlFiltersChange,
    rangeFrom,
    onRangeFromChange,
    rangeTo,
    onRangeToChange,
    filterControls,
    savedQuery,
    setSavedQuery,
    clearSavedQuery
  } = (0, _use_alert_search_bar_state_container.useAlertSearchBarStateContainer)(_constants.ALERTS_SEARCH_BAR_PARAMS_URL_STORAGE_KEY);
  (0, _react.useEffect)(() => {
    if (spaces) {
      spaces.getActiveSpace().then(space => setSpaceId(space.id));
    }
  }, [spaces]);
  (0, _react.useEffect)(() => {
    try {
      onActiveFeatureFiltersChange === null || onActiveFeatureFiltersChange === void 0 ? void 0 : onActiveFeatureFiltersChange([...new Set(filters.flatMap(f => f.meta.alertsFeatureIds).filter(_utils.nonNullable))]);
      onEsQueryChange((0, _build_es_query.buildEsQuery)({
        timeRange: {
          to: rangeTo,
          from: rangeFrom
        },
        kuery,
        filters: [...filters, ...controlFilters]
      }));
    } catch (error) {
      toasts.addError(error, {
        title: INVALID_QUERY_STRING_TOAST_TITLE
      });
      onKueryChange('');
    }
  }, [controlFilters, filters, kuery, onActiveFeatureFiltersChange, onEsQueryChange, onKueryChange, rangeFrom, rangeTo, toasts]);
  const onQueryChange = (0, _react.useCallback)(({
    query,
    dateRange
  }) => {
    setSavedQuery(undefined);
    timeFilterService.setTime(dateRange);
    onKueryChange(query !== null && query !== void 0 ? query : '');
    onRangeFromChange(dateRange.from);
    onRangeToChange(dateRange.to);
  }, [onKueryChange, onRangeFromChange, onRangeToChange, setSavedQuery, timeFilterService]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alerts_search_bar.default, (0, _extends2.default)({
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    query: kuery,
    onQuerySubmit: onQueryChange,
    filters: filters,
    onFiltersUpdated: onFiltersChange,
    savedQuery: savedQuery,
    onSavedQueryUpdated: setSavedQuery,
    onClearSavedQuery: clearSavedQuery
  }, rest)), showFilterControls && /*#__PURE__*/_react.default.createElement(_alert_filter_controls.AlertFilterControls, {
    dataViewSpec: {
      id: 'unified-alerts-dv',
      title: '.alerts-*'
    },
    spaceId: spaceId,
    chainingSystem: "HIERARCHICAL",
    controlsUrlState: filterControls,
    filters: controlFilters,
    onFiltersChange: onControlFiltersChange,
    services: {
      http,
      notifications,
      dataViews,
      storage: _public2.Storage
    },
    ControlGroupRenderer: _public.ControlGroupRenderer
  }));
};
exports.UrlSyncedAlertsSearchBar = UrlSyncedAlertsSearchBar;