"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertSummaryWidget = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_load_alert_summary = require("../../hooks/use_load_alert_summary");
var _components = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSummaryWidget = ({
  chartProps,
  featureIds,
  filter,
  fullSize,
  onClick = () => {},
  timeRange,
  hideChart,
  onLoaded,
  dependencies: {
    charts
  }
}) => {
  const {
    alertSummary: {
      activeAlertCount,
      activeAlerts,
      recoveredAlertCount
    },
    isLoading,
    error
  } = (0, _use_load_alert_summary.useLoadAlertSummary)({
    featureIds,
    filter,
    timeRange
  });
  (0, _react.useEffect)(() => {
    if (!isLoading && onLoaded) {
      onLoaded({
        activeAlertCount,
        recoveredAlertCount
      });
    }
  }, [activeAlertCount, isLoading, onLoaded, recoveredAlertCount]);
  const dependencyProps = {
    baseTheme: charts.theme.useChartsBaseTheme(),
    sparklineTheme: charts.theme.useSparklineOverrides()
  };
  if (isLoading) return /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetLoader, {
    fullSize: fullSize,
    isLoadingWithoutChart: hideChart
  });
  if (error) return /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetError, null);
  return fullSize ?
  // Only show full size version if there is data
  activeAlertCount || recoveredAlertCount ? /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetFullSize, {
    activeAlertCount: activeAlertCount,
    activeAlerts: activeAlerts,
    chartProps: chartProps,
    dateFormat: timeRange.dateFormat,
    recoveredAlertCount: recoveredAlertCount,
    hideChart: hideChart,
    dependencyProps: dependencyProps
  }) : null : /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetCompact, {
    activeAlertCount: activeAlertCount,
    activeAlerts: activeAlerts,
    chartProps: chartProps,
    onClick: onClick,
    recoveredAlertCount: recoveredAlertCount,
    timeRangeTitle: timeRange.title,
    dependencyProps: dependencyProps
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.AlertSummaryWidget = AlertSummaryWidget;