"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRuleTypesFilter = exports.createRuleProducerFilter = exports.createMatchPhrasesFilter = exports.createMatchPhraseFilter = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const $state = {
  store: _esQuery.FilterStateStore.APP_STATE
};
/**
 * Creates a match_phrase filter without an index pattern
 */
const createMatchPhraseFilter = (field, value) => ({
  meta: {
    field,
    type: _esQuery.FILTERS.PHRASE,
    key: field,
    alias: null,
    disabled: false,
    index: undefined,
    negate: false,
    params: {
      query: value
    },
    value: undefined
  },
  $state,
  query: {
    match_phrase: {
      [field]: value
    }
  }
});

/**
 * Creates a match_phrases filter without an index pattern
 */
exports.createMatchPhraseFilter = createMatchPhraseFilter;
const createMatchPhrasesFilter = (field, values, alias = null) => ({
  meta: {
    field,
    type: _esQuery.FILTERS.PHRASES,
    key: field,
    alias,
    disabled: false,
    index: undefined,
    negate: false,
    params: values,
    value: undefined
  },
  $state,
  query: {
    bool: {
      minimum_should_match: 1,
      should: values.map(v => ({
        match_phrase: {
          [field]: v
        }
      }))
    }
  }
});

/**
 * Creates a match_phrase filter targeted to filtering alerts by producer
 */
exports.createMatchPhrasesFilter = createMatchPhrasesFilter;
const createRuleProducerFilter = producer => createMatchPhraseFilter(_ruleDataUtils.ALERT_RULE_PRODUCER, producer);

/**
 * Creates a match_phrase filter targeted to filtering alerts by rule type ids
 */
exports.createRuleProducerFilter = createRuleProducerFilter;
const createRuleTypesFilter = (featureIds, alias, ruleTypeIds) => {
  const filter = createMatchPhrasesFilter(_ruleDataUtils.ALERT_RULE_TYPE_ID, ruleTypeIds, alias);
  filter.meta.alertsFeatureIds = featureIds;
  return filter;
};
exports.createRuleTypesFilter = createRuleTypesFilter;