"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRules = loadRules;
var _constants = require("../../constants");
var _map_filters_to_kql = require("./map_filters_to_kql");
var _rules_helpers = require("./rules_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadRules({
  http,
  page,
  searchText,
  typesFilter,
  actionTypesFilter,
  ruleExecutionStatusesFilter,
  ruleStatusesFilter,
  tagsFilter,
  sort = {
    field: 'name',
    direction: 'asc'
  }
}) {
  const filters = (0, _map_filters_to_kql.mapFiltersToKql)({
    typesFilter,
    actionTypesFilter,
    tagsFilter,
    ruleExecutionStatusesFilter,
    ruleStatusesFilter
  });
  const res = await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rules/_find`, {
    query: {
      page: page.index + 1,
      per_page: page.size,
      search_fields: searchText ? JSON.stringify(['name', 'tags']) : undefined,
      search: searchText,
      filter: filters.length ? filters.join(' and ') : undefined,
      default_search_operator: 'AND',
      sort_field: sort.field,
      sort_order: sort.direction
    }
  });
  return {
    page: res.page,
    perPage: res.per_page,
    total: res.total,
    data: (0, _rules_helpers.rewriteRulesResponseRes)(res.data)
  };
}