"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRule = createRule;
exports.rewriteBodyRequest = void 0;
var _constants = require("../../constants");
var _common_transformations = require("./common_transformations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRequest = ({
  ruleTypeId,
  actions,
  alertDelay,
  ...res
}) => ({
  ...res,
  rule_type_id: ruleTypeId,
  actions: actions.map(action => {
    const {
      id,
      params
    } = action;
    return {
      ...('group' in action && action.group ? {
        group: action.group
      } : {}),
      id,
      params,
      ...('frequency' in action && action.frequency ? {
        frequency: {
          notify_when: action.frequency.notifyWhen,
          throttle: action.frequency.throttle,
          summary: action.frequency.summary
        }
      } : {}),
      ...('alertsFilter' in action && action.alertsFilter ? {
        alerts_filter: action.alertsFilter
      } : {}),
      ...('useAlertDataForTemplate' in action && typeof action.useAlertDataForTemplate !== 'undefined' ? {
        use_alert_data_for_template: action.useAlertDataForTemplate
      } : {})
    };
  }),
  ...(alertDelay ? {
    alert_delay: alertDelay
  } : {})
});
exports.rewriteBodyRequest = rewriteBodyRequest;
async function createRule({
  http,
  rule
}) {
  const res = await http.post(`${_constants.BASE_ALERTING_API_PATH}/rule`, {
    body: JSON.stringify(rewriteBodyRequest(rule))
  });
  return (0, _common_transformations.transformRule)(res);
}