"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkEditResponse = useBulkEditResponse;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana = require("../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const successMessage = (total, property) => _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleApi.bulkEditResponse.success', {
  defaultMessage: 'Updated {property} for {total, plural, one {# rule} other {# rules}}.',
  values: {
    total,
    property
  }
});
const someSuccessMessage = (success, failure, property) => _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleApi.bulkEditResponse.someSuccess', {
  defaultMessage: 'Updated {property} for {success, plural, one {# rule} other {# rules}}, {failure, plural, one {# rule} other {# rules}} encountered errors.',
  values: {
    success,
    failure,
    property
  }
});
const failureMessage = (failure, property) => _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleApi.bulkEditResponse.failure', {
  defaultMessage: 'Failed to update {property} for {failure, plural, one {# rule} other {# rules}}.',
  values: {
    failure,
    property
  }
});
const snooze = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleApi.bulkEditResponse.property.snoozeSettings', {
  defaultMessage: 'snooze settings'
});
const snoozeSchedule = snooze;
const apiKey = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleApi.bulkEditResponse.property.apiKey', {
  defaultMessage: 'API key'
});
const translationMap = {
  snooze,
  snoozeSchedule,
  apiKey
};
function useBulkEditResponse(props) {
  const {
    onSearchPopulate
  } = props;
  const {
    i18n: i18nStart,
    theme,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const onSearchPopulateInternal = (0, _react.useCallback)(response => {
    if (!onSearchPopulate) {
      return;
    }
    const filter = response.errors.map(error => error.rule.name).join(',');
    onSearchPopulate(filter);
  }, [onSearchPopulate]);
  const renderToastErrorBody = (0, _react.useCallback)(response => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, onSearchPopulate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "search",
      size: "xs",
      flush: "left",
      onClick: () => onSearchPopulateInternal(response),
      "data-test-subj": "bulkEditResponseFilterErrors"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleApi.bulkEditResponse.filterByErrors",
      defaultMessage: "Filter by errored rules"
    })))));
  }, [onSearchPopulate, onSearchPopulateInternal]);
  const showToast = (0, _react.useCallback)((response, property) => {
    const {
      errors,
      total
    } = response;
    const numberOfSuccess = total - errors.length;
    const numberOfErrors = errors.length;

    // All success
    if (!numberOfErrors) {
      toasts.addSuccess(successMessage(numberOfSuccess, translationMap[property]));
      return;
    }

    // All failure
    if (numberOfErrors === total) {
      toasts.addDanger({
        title: failureMessage(numberOfErrors, translationMap[property]),
        text: (0, _reactKibanaMount.toMountPoint)(renderToastErrorBody(response), {
          i18n: i18nStart,
          theme
        })
      });
      return;
    }

    // Some failure
    toasts.addWarning({
      title: someSuccessMessage(numberOfSuccess, numberOfErrors, translationMap[property]),
      text: (0, _reactKibanaMount.toMountPoint)(renderToastErrorBody(response), {
        i18n: i18nStart,
        theme
      })
    });
  }, [i18nStart, theme, toasts, renderToastErrorBody]);
  return (0, _react.useMemo)(() => {
    return {
      showToast
    };
  }, [showToast]);
}