"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertDataViews = useAlertDataViews;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _alert_index = require("../lib/rule_api/alert_index");
var _alert_fields = require("../lib/rule_api/alert_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAlertDataViews(featureIds) {
  const {
    http,
    data: dataService,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const [dataViews, setDataViews] = (0, _react.useState)(undefined);
  const features = featureIds.sort().join(',');
  const isOnlySecurity = featureIds.length === 1 && featureIds.includes(_ruleDataUtils.AlertConsumers.SIEM);
  const hasSecurityAndO11yFeatureIds = featureIds.length > 1 && featureIds.includes(_ruleDataUtils.AlertConsumers.SIEM);
  const hasNoSecuritySolution = featureIds.length > 0 && !isOnlySecurity && !hasSecurityAndO11yFeatureIds;
  const queryIndexNameFn = () => {
    return (0, _alert_index.fetchAlertIndexNames)({
      http,
      features
    });
  };
  const queryAlertFieldsFn = () => {
    return (0, _alert_fields.fetchAlertFields)({
      http,
      featureIds
    });
  };
  const onErrorFn = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.useAlertDataView.useAlertDataMessage', {
      defaultMessage: 'Unable to load alert data view'
    }));
  };
  const {
    data: indexNames,
    isSuccess: isIndexNameSuccess,
    isInitialLoading: isIndexNameInitialLoading,
    isLoading: isIndexNameLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadAlertIndexNames', features],
    queryFn: queryIndexNameFn,
    onError: onErrorFn,
    refetchOnWindowFocus: false,
    enabled: featureIds.length > 0 && !hasSecurityAndO11yFeatureIds
  });
  const {
    data: alertFields,
    isSuccess: isAlertFieldsSuccess,
    isInitialLoading: isAlertFieldsInitialLoading,
    isLoading: isAlertFieldsLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadAlertFields', features],
    queryFn: queryAlertFieldsFn,
    onError: onErrorFn,
    refetchOnWindowFocus: false,
    enabled: hasNoSecuritySolution
  });
  (0, _react.useEffect)(() => {
    return () => {
      dataViews === null || dataViews === void 0 ? void 0 : dataViews.map(dv => {
        dataService.dataViews.clearInstanceCache(dv.id);
      });
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataViews]);

  // FUTURE ENGINEER this useEffect is for security solution user since
  // we are using the user privilege to access the security alert index
  (0, _react.useEffect)(() => {
    async function createDataView() {
      const localDataview = await dataService.dataViews.create({
        title: (indexNames !== null && indexNames !== void 0 ? indexNames : []).join(','),
        allowNoIndex: true
      });
      setDataViews([localDataview]);
    }
    if (isOnlySecurity && isIndexNameSuccess) {
      createDataView();
    }
  }, [dataService.dataViews, indexNames, isIndexNameSuccess, isOnlySecurity]);

  // FUTURE ENGINEER this useEffect is for o11y and stack solution user since
  // we are using the kibana user privilege to access the alert index
  (0, _react.useEffect)(() => {
    if (indexNames && alertFields && !isOnlySecurity && isAlertFieldsSuccess && isIndexNameSuccess) {
      var _ref;
      setDataViews([{
        title: (indexNames !== null && indexNames !== void 0 ? indexNames : []).join(','),
        fieldFormatMap: {},
        fields: (_ref = alertFields !== null && alertFields !== void 0 ? alertFields : []) === null || _ref === void 0 ? void 0 : _ref.map(field => {
          return {
            ...field,
            ...(field.esTypes && field.esTypes.includes('flattened') ? {
              type: 'string'
            } : {})
          };
        })
      }]);
    }
  }, [alertFields, dataService.dataViews, indexNames, isIndexNameSuccess, isOnlySecurity, isAlertFieldsSuccess]);
  return (0, _react.useMemo)(() => ({
    dataViews,
    loading: featureIds.length === 0 || hasSecurityAndO11yFeatureIds ? false : isOnlySecurity ? isIndexNameInitialLoading || isIndexNameLoading : isIndexNameInitialLoading || isIndexNameLoading || isAlertFieldsInitialLoading || isAlertFieldsLoading
  }), [dataViews, featureIds.length, hasSecurityAndO11yFeatureIds, isOnlySecurity, isIndexNameInitialLoading, isIndexNameLoading, isAlertFieldsInitialLoading, isAlertFieldsLoading]);
}