"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsFlappingTitle = exports.RulesSettingsFlappingFormSection = exports.RulesSettingsFlappingDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _rules_settings_range = require("../rules_settings_range");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lookBackWindowLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flapping.lookBackWindowLabel', {
  defaultMessage: 'Rule run look back window'
});
const lookBackWindowHelp = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flapping.lookBackWindowHelp', {
  defaultMessage: 'The minimum number of runs in which the threshold must be met.'
});
const statusChangeThresholdLabel = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flapping.statusChangeThresholdLabel', {
  defaultMessage: 'Alert status change threshold'
});
const statusChangeThresholdHelp = _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flapping.statusChangeThresholdHelp', {
  defaultMessage: 'The minimum number of times an alert must switch states in the look back window.'
});
const getLookBackWindowLabelRuleRuns = amount => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flapping.lookBackWindowLabelRuleRuns', {
    defaultMessage: '{amount, number} rule {amount, plural, one {run} other {runs}}',
    values: {
      amount
    }
  });
};
const getStatusChangeThresholdRuleRuns = amount => {
  return _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.flapping.statusChangeThresholdTimes', {
    defaultMessage: '{amount, number} {amount, plural, one {time} other {times}}',
    values: {
      amount
    }
  });
};
const RulesSettingsFlappingTitle = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.flapping.alertFlappingDetection",
    defaultMessage: "Alert flapping detection"
  })));
};
exports.RulesSettingsFlappingTitle = RulesSettingsFlappingTitle;
const RulesSettingsFlappingDescription = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.flapping.alertFlappingDetectionDescription",
    defaultMessage: "Modify the frequency that an alert can go between active and recovered over a period of rule runs."
  }));
};
exports.RulesSettingsFlappingDescription = RulesSettingsFlappingDescription;
const RulesSettingsFlappingFormSection = exports.RulesSettingsFlappingFormSection = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    flappingSettings,
    compressed = false,
    onChange,
    canWrite
  } = props;
  const {
    lookBackWindow,
    statusChangeThreshold
  } = flappingSettings;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, compressed && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RulesSettingsFlappingTitle, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(RulesSettingsFlappingDescription, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_rules_settings_range.RulesSettingsRange, {
    "data-test-subj": "lookBackWindowRangeInput",
    min: _common.MIN_LOOK_BACK_WINDOW,
    max: _common.MAX_LOOK_BACK_WINDOW,
    value: lookBackWindow,
    onChange: e => onChange('lookBackWindow', parseInt(e.currentTarget.value, 10)),
    label: lookBackWindowLabel,
    labelPopoverText: lookBackWindowHelp,
    disabled: !canWrite
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_rules_settings_range.RulesSettingsRange, {
    "data-test-subj": "statusChangeThresholdRangeInput",
    min: _common.MIN_STATUS_CHANGE_THRESHOLD,
    max: _common.MAX_STATUS_CHANGE_THRESHOLD,
    value: statusChangeThreshold,
    onChange: e => onChange('statusChangeThreshold', parseInt(e.currentTarget.value, 10)),
    label: statusChangeThresholdLabel,
    labelPopoverText: statusChangeThresholdHelp,
    disabled: !canWrite
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.flapping.flappingSettingsDescription",
    defaultMessage: "An alert is flapping if it changes status at least {statusChangeThreshold} in the last {lookBackWindow}.",
    values: {
      lookBackWindow: /*#__PURE__*/_react.default.createElement("b", null, getLookBackWindowLabelRuleRuns(lookBackWindow)),
      statusChangeThreshold: /*#__PURE__*/_react.default.createElement("b", null, getStatusChangeThresholdRuleRuns(statusChangeThreshold))
    }
  })))));
});