"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MustacheTextFieldWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _react = _interopRequireWildcard(require("react"));
var _text_field_with_message_variables = require("./text_field_with_message_variables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MustacheTextFieldWrapper = ({
  field,
  euiFieldProps,
  idAria,
  ...rest
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const {
    value,
    setValue
  } = field;
  const editAction = (0, _react.useCallback)((property, newValue) => {
    setValue(newValue);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_text_field_with_message_variables.TextFieldWithMessageVariables, (0, _extends2.default)({
    errors: errorMessage ? [errorMessage] : [],
    formRowProps: {
      describedByIds: idAria ? [idAria] : undefined,
      error: errorMessage,
      fullWidth: true,
      helpText: typeof field.helpText === 'function' ? field.helpText() : field.helpText,
      isInvalid,
      label: field.label,
      ...rest
    },
    index: 0,
    inputTargetValue: value,
    wrapField: true
  }, euiFieldProps, {
    editAction: editAction
  }));
};
exports.MustacheTextFieldWrapper = MustacheTextFieldWrapper;