"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/discover-plugin/common");
var _use_search_items = require("../../../../hooks/use_search_items");
var _app_dependencies = require("../../../../app_dependencies");
var _discover_action_name = require("./discover_action_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDiscoverAction = forceDisable => {
  var _capabilities$discove;
  const {
    share,
    data: {
      dataViews: dataViewsContract
    },
    application: {
      capabilities
    }
  } = (0, _app_dependencies.useAppDependencies)();
  const isDiscoverAvailable = !!((_capabilities$discove = capabilities.discover) !== null && _capabilities$discove !== void 0 && _capabilities$discove.show);
  const {
    getDataViewIdByTitle,
    loadDataViews
  } = (0, _use_search_items.useSearchItems)(undefined);
  const [dataViewsLoaded, setDataViewsLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    async function checkDataViewAvailability() {
      await loadDataViews(dataViewsContract);
      setDataViewsLoaded(true);
    }
    checkDataViewAvailability();
  }, [loadDataViews, dataViewsContract]);
  const clickHandler = (0, _react.useCallback)(item => {
    const locator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);
    if (!locator) return;
    const dataViewId = getDataViewIdByTitle(item.config.dest.index);
    locator.navigateSync({
      indexPatternId: dataViewId
    });
  }, [getDataViewIdByTitle, share]);
  const dataViewExists = (0, _react.useCallback)(item => {
    const dataViewId = getDataViewIdByTitle(item.config.dest.index);
    return dataViewId !== undefined;
  }, [getDataViewIdByTitle]);
  const action = (0, _react.useMemo)(() => ({
    name: item => {
      return /*#__PURE__*/_react.default.createElement(_discover_action_name.DiscoverActionName, {
        items: [item],
        dataViewExists: dataViewExists(item)
      });
    },
    available: () => isDiscoverAvailable,
    enabled: item => dataViewsLoaded && !(0, _discover_action_name.isDiscoverActionDisabled)([item], forceDisable, dataViewExists(item)),
    description: _discover_action_name.discoverActionNameText,
    icon: 'visTable',
    type: 'icon',
    onClick: clickHandler,
    'data-test-subj': 'transformActionDiscover'
  }), [forceDisable, dataViewExists, dataViewsLoaded, isDiscoverAvailable, clickHandler]);
  return {
    action
  };
};
exports.useDiscoverAction = useDiscoverAction;