"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wizard = exports.CreateTransformWizardContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _common = require("@kbn/data-plugin/common");
var _serverless_context = require("../../../../serverless_context");
var _common2 = require("../../../../common");
var _app_dependencies = require("../../../../app_dependencies");
var _step_define = require("../step_define");
var _step_create = require("../step_create");
var _step_details = require("../step_details");
var _wizard_nav = require("../wizard_nav");
var _storage = require("./storage");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);
var WIZARD_STEPS = /*#__PURE__*/function (WIZARD_STEPS) {
  WIZARD_STEPS[WIZARD_STEPS["DEFINE"] = 0] = "DEFINE";
  WIZARD_STEPS[WIZARD_STEPS["DETAILS"] = 1] = "DETAILS";
  WIZARD_STEPS[WIZARD_STEPS["CREATE"] = 2] = "CREATE";
  return WIZARD_STEPS;
}(WIZARD_STEPS || {});
const StepDefine = ({
  isCurrentStep,
  stepDefineState,
  setCurrentStep,
  setStepDefineState,
  searchItems
}) => {
  const definePivotRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    ref: definePivotRef
  }), isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_step_define.StepDefineForm, {
    onChange: setStepDefineState,
    overrides: {
      ...stepDefineState
    },
    searchItems: searchItems
  }), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    next: () => setCurrentStep(WIZARD_STEPS.DETAILS),
    nextActive: stepDefineState.valid
  })), !isCurrentStep && /*#__PURE__*/_react.default.createElement(_step_define.StepDefineSummary, {
    formState: {
      ...stepDefineState
    },
    searchItems: searchItems
  }));
};
const CreateTransformWizardContext = exports.CreateTransformWizardContext = /*#__PURE__*/(0, _react.createContext)({
  dataView: null,
  runtimeMappings: undefined
});
const Wizard = exports.Wizard = /*#__PURE__*/_react.default.memo(({
  cloneConfig,
  searchItems
}) => {
  const {
    showNodeInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const appDependencies = (0, _app_dependencies.useAppDependencies)();
  const {
    ml: {
      FieldStatsFlyoutProvider
    },
    uiSettings,
    data,
    fieldFormats,
    charts
  } = appDependencies;
  const {
    dataView
  } = searchItems;

  // The current WIZARD_STEP
  const [currentStep, setCurrentStep] = (0, _react.useState)(WIZARD_STEPS.DEFINE);

  // The DEFINE state
  const [stepDefineState, setStepDefineState] = (0, _react.useState)((0, _step_define.applyTransformConfigToDefineState)((0, _step_define.getDefaultStepDefineState)(searchItems), cloneConfig, dataView));

  // The DETAILS state
  const [stepDetailsState, setStepDetailsState] = (0, _react.useState)((0, _step_details.applyTransformConfigToDetailsState)((0, _step_details.getDefaultStepDetailsState)(), cloneConfig));

  // The CREATE state
  const [stepCreateState, setStepCreateState] = (0, _react.useState)(_step_create.getDefaultStepCreateState);
  const transformConfig = (0, _common2.getCreateTransformRequestBody)(dataView, stepDefineState, stepDetailsState);
  const stepDefine = (0, _react.useMemo)(() => {
    return {
      title: _i18n.i18n.translate('xpack.transform.transformsWizard.stepConfigurationTitle', {
        defaultMessage: 'Configuration'
      }),
      children: /*#__PURE__*/_react.default.createElement(StepDefine, {
        isCurrentStep: currentStep === WIZARD_STEPS.DEFINE,
        stepDefineState: stepDefineState,
        setCurrentStep: setCurrentStep,
        setStepDefineState: setStepDefineState,
        searchItems: searchItems
      })
    };
  }, [currentStep, stepDefineState, setCurrentStep, setStepDefineState, searchItems]);
  const stepDetails = (0, _react.useMemo)(() => {
    return {
      title: _i18n.i18n.translate('xpack.transform.transformsWizard.stepDetailsTitle', {
        defaultMessage: 'Transform details'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentStep === WIZARD_STEPS.DETAILS ? /*#__PURE__*/_react.default.createElement(_step_details.StepDetailsForm, {
        onChange: setStepDetailsState,
        overrides: stepDetailsState,
        searchItems: searchItems,
        stepDefineState: stepDefineState
      }) : /*#__PURE__*/_react.default.createElement(_step_details.StepDetailsSummary, stepDetailsState), currentStep === WIZARD_STEPS.DETAILS && /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
        previous: () => {
          setCurrentStep(WIZARD_STEPS.DEFINE);
        },
        next: () => setCurrentStep(WIZARD_STEPS.CREATE),
        nextActive: stepDetailsState.valid
      })),
      status: currentStep >= WIZARD_STEPS.DETAILS ? undefined : 'incomplete'
    };
  }, [currentStep, setStepDetailsState, stepDetailsState, searchItems, stepDefineState]);
  const stepCreate = (0, _react.useMemo)(() => {
    return {
      title: _i18n.i18n.translate('xpack.transform.transformsWizard.stepCreateTitle', {
        defaultMessage: 'Create'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentStep === WIZARD_STEPS.CREATE ? /*#__PURE__*/_react.default.createElement(_step_create.StepCreateForm, {
        createDataView: stepDetailsState.createDataView,
        transformId: stepDetailsState.transformId,
        transformConfig: transformConfig,
        onChange: setStepCreateState,
        overrides: stepCreateState,
        timeFieldName: stepDetailsState.dataViewTimeField
      }) : /*#__PURE__*/_react.default.createElement(_step_create.StepCreateSummary, null), currentStep === WIZARD_STEPS.CREATE && !stepCreateState.created && /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
        previous: () => setCurrentStep(WIZARD_STEPS.DETAILS)
      })),
      status: currentStep >= WIZARD_STEPS.CREATE ? undefined : 'incomplete'
    };
  }, [currentStep, setCurrentStep, stepDetailsState.createDataView, stepDetailsState.transformId, transformConfig, setStepCreateState, stepCreateState, stepDetailsState.dataViewTimeField]);
  const stepsConfig = [stepDefine, stepDetails, stepCreate];
  const datePickerDeps = {
    ...(0, _lodash.pick)(appDependencies, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice: showNodeInfo
  };
  const fieldStatsServices = (0, _react.useMemo)(() => ({
    uiSettings,
    dataViews: data.dataViews,
    data,
    fieldFormats,
    charts
  }), [uiSettings, data, fieldFormats, charts]);
  return /*#__PURE__*/_react.default.createElement(FieldStatsFlyoutProvider, {
    dataView: dataView,
    fieldStatsServices: fieldStatsServices,
    timeRangeMs: stepDefineState.timeRangeMs,
    dslQuery: transformConfig.source.query
  }, /*#__PURE__*/_react.default.createElement(CreateTransformWizardContext.Provider, {
    value: {
      dataView,
      runtimeMappings: stepDefineState.runtimeMappings
    }
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, null, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.TRANSFORM_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    className: "transform__steps",
    steps: stepsConfig
  }))))));
});