"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDefineForm = exports.ConfigSectionTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _constants = require("../../../../../../common/constants");
var _storage = require("../../../../../../common/types/storage");
var _data_grid = require("../../../../common/data_grid");
var _common = require("../../../../common");
var _use_documentation_links = require("../../../../hooks/use_documentation_links");
var _use_index_data = require("../../../../hooks/use_index_data");
var _use_transform_config_data = require("../../../../hooks/use_transform_config_data");
var _app_dependencies = require("../../../../app_dependencies");
var _pivot_aggs = require("../../../../common/pivot_aggs");
var _advanced_query_editor_switch = require("../advanced_query_editor_switch");
var _advanced_source_editor = require("../advanced_source_editor");
var _date_picker_apply_switch = require("../date_picker_apply_switch");
var _source_search_bar = require("../source_search_bar");
var _advanced_runtime_mappings_settings = require("../advanced_runtime_mappings_settings");
var _use_step_define_form = require("./hooks/use_step_define_form");
var _transform_function_selector = require("./transform_function_selector");
var _latest_function_form = require("./latest_function_form");
var _pivot_function_form = require("./pivot_function_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALLOW_TIME_RANGE_ON_TRANSFORM_CONFIG = false;
const advancedEditorsSidebarWidth = '220px';
const isPopulatedFields = arg => arg instanceof Set;
const ConfigSectionTitle = ({
  title
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("span", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}));
exports.ConfigSectionTitle = ConfigSectionTitle;
const StepDefineForm = exports.StepDefineForm = /*#__PURE__*/_react.default.memo(props => {
  var _searchItems$savedSea, _searchItems$savedSea2;
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    searchItems
  } = props;
  const {
    dataView
  } = searchItems;
  const indexPattern = (0, _react.useMemo)(() => dataView.getIndexPattern(), [dataView]);
  const [frozenDataPreference, setFrozenDataPreference] = (0, _mlLocalStorage.useStorage)(_storage.TRANSFORM_FROZEN_TIER_PREFERENCE,
  // By default we will exclude frozen data tier
  _mlDatePicker.FROZEN_TIER_PREFERENCE.EXCLUDE);
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const stepDefineForm = (0, _use_step_define_form.useStepDefineForm)(props);
  const {
    advancedEditorConfig
  } = stepDefineForm.advancedPivotEditor.state;
  const {
    advancedEditorSourceConfig,
    isAdvancedSourceEditorEnabled,
    isAdvancedSourceEditorApplyButtonEnabled
  } = stepDefineForm.advancedSourceEditor.state;
  const {
    isDatePickerApplyEnabled,
    timeRangeMs
  } = stepDefineForm.datePicker.state;
  const {
    transformConfigQuery
  } = stepDefineForm.searchBar.state;
  const {
    runtimeMappings
  } = stepDefineForm.runtimeMappingsEditor.state;
  const appDependencies = (0, _app_dependencies.useAppDependencies)();
  const {
    ml: {
      useFieldStatsFlyoutContext
    }
  } = appDependencies;
  const fieldStatsContext = useFieldStatsFlyoutContext();
  const indexPreviewProps = {
    ...(0, _use_index_data.useIndexData)(dataView, transformConfigQuery, runtimeMappings, timeRangeMs, isPopulatedFields(fieldStatsContext === null || fieldStatsContext === void 0 ? void 0 : fieldStatsContext.populatedFields) ? [...fieldStatsContext.populatedFields] : []),
    dataTestSubj: 'transformIndexPreview',
    toastNotifications
  };
  const {
    requestPayload,
    validationStatus
  } = stepDefineForm.transformFunction === _constants.TRANSFORM_FUNCTION.PIVOT ? stepDefineForm.pivotConfig.state : stepDefineForm.latestFunctionConfig;
  const copyToClipboardSource = (0, _data_grid.getIndexDevConsoleStatement)(transformConfigQuery, indexPattern);
  const copyToClipboardSourceDescription = _i18n.i18n.translate('xpack.transform.indexPreview.copyClipboardTooltip', {
    defaultMessage: 'Copy Dev Console statement of the index preview to the clipboard.'
  });
  const copyToClipboardPreviewRequest = (0, _common.getPreviewTransformRequestBody)(dataView, transformConfigQuery, requestPayload, runtimeMappings, isDatePickerApplyEnabled ? timeRangeMs : undefined);
  const copyToClipboardPivot = (0, _data_grid.getTransformPreviewDevConsoleStatement)(copyToClipboardPreviewRequest);
  const copyToClipboardPivotDescription = _i18n.i18n.translate('xpack.transform.pivotPreview.copyClipboardTooltip', {
    defaultMessage: 'Copy Dev Console statement of the transform preview to the clipboard.'
  });
  const previewProps = {
    ...(0, _use_transform_config_data.useTransformConfigData)(dataView, transformConfigQuery, validationStatus, requestPayload, runtimeMappings, timeRangeMs),
    dataTestSubj: 'transformPivotPreview',
    toastNotifications,
    ...(stepDefineForm.transformFunction === _constants.TRANSFORM_FUNCTION.LATEST ? {
      copyToClipboard: copyToClipboardPivot,
      copyToClipboardDescription: copyToClipboardPivotDescription
    } : {})
  };
  const applySourceChangesHandler = () => {
    const sourceConfig = JSON.parse(advancedEditorSourceConfig);
    stepDefineForm.searchBar.actions.setSearchQuery(sourceConfig);
    stepDefineForm.advancedSourceEditor.actions.applyAdvancedSourceEditorChanges();
  };
  const applyPivotChangesHandler = () => {
    const pivot = JSON.parse(stepDefineForm.advancedPivotEditor.actions.convertToJson(advancedEditorConfig));
    const newGroupByList = {};
    if (pivot !== undefined && pivot.group_by !== undefined) {
      Object.entries(pivot.group_by).forEach(d => {
        const aggName = d[0];
        const aggConfig = d[1];
        const aggConfigKeys = Object.keys(aggConfig);
        const agg = aggConfigKeys[0];
        newGroupByList[aggName] = {
          ...aggConfig[agg],
          agg,
          aggName,
          dropDownName: ''
        };
      });
    }
    stepDefineForm.pivotConfig.actions.setGroupByList(newGroupByList);
    const newAggList = {};
    if (pivot !== undefined && pivot.aggregations !== undefined) {
      Object.entries(pivot.aggregations).forEach(d => {
        const aggName = d[0];
        const aggConfig = d[1];
        newAggList[aggName] = (0, _pivot_aggs.getAggConfigFromEsAgg)(aggConfig, aggName);
      });
    }
    stepDefineForm.pivotConfig.actions.setAggList(newAggList);
    stepDefineForm.advancedPivotEditor.actions.setAdvancedEditorConfigLastApplied(advancedEditorConfig);
    stepDefineForm.advancedPivotEditor.actions.setAdvancedPivotEditorApplyButtonEnabled(false);
  };
  const {
    esQueryDsl
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const hasValidTimeField = (0, _react.useMemo)(() => dataView.timeFieldName !== undefined && dataView.timeFieldName !== '', [dataView.timeFieldName]);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: (dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== undefined,
    autoRefreshSelector: false
  });
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.time) !== undefined) {
      timefilter.setTime({
        from: globalState.time.from,
        to: globalState.time.to
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.time), timefilter]);
  (0, _react.useEffect)(() => {
    if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
      timefilter.setRefreshInterval(globalState.refreshInterval);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval), timefilter]);
  (0, _react.useEffect)(() => {
    const timeUpdateSubscription = (0, _rxjs.merge)(timefilter.getAutoRefreshFetch$(), timefilter.getTimeUpdate$(), _mlDatePicker.mlTimefilterRefresh$).subscribe(() => {
      if (setGlobalState) {
        setGlobalState({
          time: timefilter.getTime(),
          refreshInterval: timefilter.getRefreshInterval()
        });
      }
    });
    return () => {
      timeUpdateSubscription.unsubscribe();
    };
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformStepDefineForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_transform_function_selector.TransformFunctionSelector, {
    selectedFunction: stepDefineForm.transformFunction,
    onChange: stepDefineForm.setTransformFunction
  })), /*#__PURE__*/_react.default.createElement(ConfigSectionTitle, {
    title: "Source data"
  }), searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.dataViewLabel', {
      defaultMessage: 'Data view'
    })
  }, /*#__PURE__*/_react.default.createElement("span", null, indexPattern)), hasValidTimeField && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.transform.stepDefineForm.datePickerLabel', {
      defaultMessage: 'Time range'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.transform.stepDefineForm.datePickerIconTipContent', {
        defaultMessage: 'The time range is applied to previews only and will not be part of the final transform configuration.'
      })
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerWrapper, {
    isAutoRefreshOnly: !hasValidTimeField,
    showRefresh: !hasValidTimeField,
    width: "full"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    }
  }, ALLOW_TIME_RANGE_ON_TRANSFORM_CONFIG && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_date_picker_apply_switch.DatePickerApplySwitch, stepDefineForm))), /*#__PURE__*/_react.default.createElement(_mlDatePicker.FullTimeRangeSelector, {
    frozenDataPreference: frozenDataPreference,
    setFrozenDataPreference: setFrozenDataPreference,
    dataView: dataView,
    query: undefined,
    disabled: false,
    timefilter: timefilter
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: (searchItems === null || searchItems === void 0 ? void 0 : (_searchItems$savedSea = searchItems.savedSearch) === null || _searchItems$savedSea === void 0 ? void 0 : _searchItems$savedSea.id) !== undefined ? _i18n.i18n.translate('xpack.transform.stepDefineForm.savedSearchLabel', {
      defaultMessage: 'Saved search'
    }) : _i18n.i18n.translate('xpack.transform.stepDefineForm.searchFilterLabel', {
      defaultMessage: 'Search filter'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isAdvancedSourceEditorEnabled && /*#__PURE__*/_react.default.createElement(_source_search_bar.SourceSearchBar, {
    dataView: dataView,
    searchBar: stepDefineForm.searchBar
  }), isAdvancedSourceEditorEnabled && /*#__PURE__*/_react.default.createElement(_advanced_source_editor.AdvancedSourceEditor, stepDefineForm)), (searchItems === null || searchItems === void 0 ? void 0 : (_searchItems$savedSea2 = searchItems.savedSearch) === null || _searchItems$savedSea2 === void 0 ? void 0 : _searchItems$savedSea2.id) !== undefined && /*#__PURE__*/_react.default.createElement("span", null, searchItems.savedSearch.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_advanced_query_editor_switch.AdvancedQueryEditorSwitch, stepDefineForm)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: copyToClipboardSourceDescription,
    textToCopy: copyToClipboardSource
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": copyToClipboardSourceDescription
  }))))), isAdvancedSourceEditorEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: advancedEditorsSidebarWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorHelpText', {
    defaultMessage: 'The advanced editor allows you to edit the source query clause of the transform configuration.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: esQueryDsl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorHelpTextLink', {
    defaultMessage: 'Learn more about available options.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    style: {
      width: 'fit-content'
    },
    size: "s",
    fill: true,
    onClick: applySourceChangesHandler,
    disabled: !isAdvancedSourceEditorApplyButtonEnabled
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedSourceEditorApplyButtonText', {
    defaultMessage: 'Apply changes'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_advanced_runtime_mappings_settings.AdvancedRuntimeMappingsSettings, stepDefineForm), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.dataGridLabel', {
      defaultMessage: 'Source documents'
    })
  }, /*#__PURE__*/_react.default.createElement(_mlDataGrid.DataGrid, indexPreviewProps))))), /*#__PURE__*/_react.default.createElement(ConfigSectionTitle, {
    title: "Transform configuration"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, stepDefineForm.transformFunction === _constants.TRANSFORM_FUNCTION.PIVOT ? /*#__PURE__*/_react.default.createElement(_pivot_function_form.PivotFunctionForm, {
    applyPivotChangesHandler,
    copyToClipboardPivot,
    copyToClipboardPivotDescription,
    stepDefineForm
  }) : null, stepDefineForm.transformFunction === _constants.TRANSFORM_FUNCTION.LATEST ? /*#__PURE__*/_react.default.createElement(_latest_function_form.LatestFunctionForm, {
    copyToClipboard: copyToClipboardPivot,
    copyToClipboardDescription: copyToClipboardPivotDescription,
    latestFunctionService: stepDefineForm.latestFunctionConfig
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), (stepDefineForm.transformFunction !== _constants.TRANSFORM_FUNCTION.LATEST || stepDefineForm.latestFunctionConfig.sortFieldOptions.length > 0) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.previewLabel', {
      defaultMessage: 'Preview'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_mlDataGrid.DataGrid, previewProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))));
});