"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterAggForm = void 0;
exports.getSupportedFilterAggs = getSupportedFilterAggs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _wizard = require("../../../../wizard/wizard");
var _constants = require("../constants");
var _config = require("../config");
var _get_pivot_dropdown_options = require("../../get_pivot_dropdown_options");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Resolves supported filters for provided field.
 */
function getSupportedFilterAggs(fieldName, dataView, runtimeMappings) {
  const dataViewField = dataView.fields.getByName(fieldName);
  if (dataViewField !== undefined) {
    return [..._constants.commonFilterAggs, ..._constants.filterAggsFieldSupport[dataViewField.type]];
  }
  if ((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeMappings) && runtimeMappings.hasOwnProperty(fieldName)) {
    const runtimeField = runtimeMappings[fieldName];
    return [..._constants.commonFilterAggs, ..._constants.filterAggsFieldSupport[(0, _get_pivot_dropdown_options.getKibanaFieldTypeFromEsType)(runtimeField.type)]];
  }

  // Some aggs like filter boolean might have fields that don't exist
  // but we still support it as JSON
  // eslint-disable-next-line no-console
  console.error(`The field ${fieldName} does not exist in the index or runtime fields`);
}

/**
 * Component for filter aggregation related controls.
 *
 * Responsible for the filter agg type selection and rendering of
 * the corresponded field set.
 */
const FilterAggForm = ({
  aggConfig,
  onChange,
  selectedField
}) => {
  var _aggConfig$filterAgg;
  const {
    dataView,
    runtimeMappings
  } = (0, _react.useContext)(_wizard.CreateTransformWizardContext);
  const filterAggsOptions = (0, _react.useMemo)(() => getSupportedFilterAggs(selectedField, dataView, runtimeMappings), [dataView, selectedField, runtimeMappings]);
  (0, _useUpdateEffect.default)(function resetConfigOnFieldChange() {
    // reset filter agg on field change
    onChange({});
  }, [selectedField]);
  const filterAggTypeConfig = aggConfig === null || aggConfig === void 0 ? void 0 : aggConfig.aggTypeConfig;
  const filterAgg = (_aggConfig$filterAgg = aggConfig === null || aggConfig === void 0 ? void 0 : aggConfig.filterAgg) !== null && _aggConfig$filterAgg !== void 0 ? _aggConfig$filterAgg : '';
  const isValid = filterAggTypeConfig !== null && filterAggTypeConfig !== void 0 && filterAggTypeConfig.isValid ? filterAggTypeConfig === null || filterAggTypeConfig === void 0 ? void 0 : filterAggTypeConfig.isValid() : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filterAggsOptions !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.filerAggLabel",
      defaultMessage: "Filter query"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.transform.agg.popoverForm.filerQueryAdvancedSuggestionTooltip",
        defaultMessage: "To add other filter query aggregations, edit the JSON config."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: [{
      text: '',
      value: ''
    }].concat(filterAggsOptions.map(v => ({
      text: v,
      value: v
    }))),
    value: filterAgg,
    onChange: e => {
      // have to reset aggTypeConfig of filterAgg change
      const filterAggUpdate = e.target.value;
      onChange({
        filterAgg: filterAggUpdate,
        aggTypeConfig: (0, _config.getFilterAggTypeConfig)(filterAggUpdate, selectedField)
      });
    },
    "data-test-subj": "transformFilterAggTypeSelector"
  })) : null, filterAgg !== '' && (filterAggTypeConfig === null || filterAggTypeConfig === void 0 ? void 0 : filterAggTypeConfig.FilterAggFormComponent) && /*#__PURE__*/_react.default.createElement(filterAggTypeConfig.FilterAggFormComponent, {
    config: filterAggTypeConfig === null || filterAggTypeConfig === void 0 ? void 0 : filterAggTypeConfig.filterAggConfig,
    onChange: update => {
      onChange({
        ...aggConfig,
        aggTypeConfig: {
          ...filterAggTypeConfig,
          filterAggConfig: update.config
        }
      });
    },
    selectedField: selectedField,
    isValid: isValid
  }));
};
exports.FilterAggForm = FilterAggForm;