"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubAggsSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _list_form = require("./list_form");
var _aggregation_dropdown = require("../aggregation_dropdown");
var _pivot_configuration = require("../pivot_configuration/pivot_configuration");
var _pivot_aggs = require("../../../../common/pivot_aggs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component for managing sub-aggregation of the provided
 * aggregation item.
 */
const SubAggsSection = ({
  item
}) => {
  const {
    state,
    actions
  } = (0, _react.useContext)(_pivot_configuration.PivotConfigurationContext);
  const addSubAggHandler = (0, _react.useCallback)(d => {
    actions.addSubAggregation(item, d);
  }, [actions, item]);
  const updateSubAggHandler = (0, _react.useCallback)((prevSubItemName, subItem) => {
    actions.updateSubAggregation(prevSubItemName, subItem);
  }, [actions]);
  const deleteSubAggHandler = (0, _react.useCallback)(subAggName => {
    actions.deleteSubAggregation(item, subAggName);
  }, [actions, item]);
  const isNewSubAggAllowed = (0, _react.useMemo)(() => {
    let nestingLevel = 1;
    let parentItem = item.parentAgg;
    while (parentItem !== undefined) {
      nestingLevel++;
      parentItem = parentItem.parentAgg;
    }
    return nestingLevel <= _pivot_aggs.MAX_NESTING_SUB_AGGS;
  }, [item]);
  const dropdown = /*#__PURE__*/_react.default.createElement(_aggregation_dropdown.DropDown, {
    changeHandler: addSubAggHandler,
    options: state.aggOptions,
    placeholder: _i18n.i18n.translate('xpack.transform.stepDefineForm.addSubAggregationPlaceholder', {
      defaultMessage: 'Add a sub-aggregation ...'
    }),
    testSubj: "transformSubAggregationSelection",
    isDisabled: !isNewSubAggAllowed
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), item.subAggs && /*#__PURE__*/_react.default.createElement(_list_form.AggListForm, {
    onChange: updateSubAggHandler,
    deleteHandler: deleteSubAggHandler,
    list: item.subAggs,
    options: state.aggOptionsData
  }), isNewSubAggAllowed ? dropdown : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: "eui-displayBlock",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.stepDefineForm.maxSubAggsLevelsLimitMessage",
      defaultMessage: "You have reached the maximum number of levels of sub-aggregations that can be added in the form. Please edit the JSON config if you want to add another level."
    })
  }, dropdown));
};
exports.SubAggsSection = SubAggsSection;