"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggLabelForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _popover_form = require("./popover_form");
var _pivot_aggs = require("../../../../common/pivot_aggs");
var _sub_aggs_section = require("./sub_aggs_section");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AggLabelForm = ({
  deleteHandler,
  item,
  otherAggNames,
  onChange,
  options
}) => {
  const [isPopoverVisible, setPopoverVisibility] = (0, _react.useState)((0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) && !item.isValid());
  function update(updateItem) {
    onChange({
      ...updateItem
    });
    setPopoverVisibility(false);
  }
  const helperText = (0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) && item.helperText && item.helperText();
  const isSubAggSupported = (0, _common.isPivotAggsConfigWithUiBase)(item) && item.isSubAggsSupported && ((0, _pivot_aggs.isPivotAggsWithExtendedForm)(item) ? item.isValid() : true);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "transform__AggregationLabel--text"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    "data-test-subj": "transformAggregationEntryLabel"
  }, item.aggName)), helperText && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    className: "eui-textTruncate",
    "data-test-subj": "transformAggHelperText",
    style: {
      lineHeight: '20px'
    }
  }, helperText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "transformFormPopover",
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.transform.aggLabelForm.editAggAriaLabel', {
        defaultMessage: 'Edit aggregation'
      }),
      size: "s",
      iconType: "pencil",
      onClick: () => setPopoverVisibility(!isPopoverVisible),
      "data-test-subj": `transformAggregationEntryEditButton_${item.aggName}`
    }),
    isOpen: isPopoverVisible,
    closePopover: () => setPopoverVisibility(false)
  }, /*#__PURE__*/_react.default.createElement(_popover_form.PopoverForm, {
    defaultData: item,
    onChange: update,
    otherAggNames: otherAggNames,
    options: options
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "transform__GroupByLabel--button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.transform.aggLabelForm.deleteItemAriaLabel', {
      defaultMessage: 'Delete item'
    }),
    size: "s",
    iconType: "cross",
    onClick: () => deleteHandler(item.aggName),
    "data-test-subj": "transformAggregationEntryDeleteButton"
  }))), isSubAggSupported && /*#__PURE__*/_react.default.createElement(_sub_aggs_section.SubAggsSection, {
    item: item
  }));
};
exports.AggLabelForm = AggLabelForm;