"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloneTransformSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _queryString = require("query-string");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
var _use_documentation_links = require("../../hooks/use_documentation_links");
var _use_search_items = require("../../hooks/use_search_items");
var _navigation = require("../../services/navigation");
var _capabilities_wrapper = require("../../components/capabilities_wrapper");
var _wizard = require("../create_transform/components/wizard");
var _transform = require("../../common/transform");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CloneTransformSection = ({
  match,
  location
}) => {
  const {
    dataViewId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs(_navigation.BREADCRUMB_SECTION.CLONE_TRANSFORM);
    _navigation.docTitleService.setTitle('createTransform');
  }, []);
  const {
    esTransform
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const transformId = match.params.transformId;
  const [transformConfig, setTransformConfig] = (0, _react.useState)();
  const [errorMessage, setErrorMessage] = (0, _react.useState)();
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const {
    error: searchItemsError,
    searchItems,
    setSavedObjectId
  } = (0, _use_search_items.useSearchItems)(undefined);
  (0, _react.useEffect)(() => {
    if (dataViewId === undefined) {
      setErrorMessage(_i18n.i18n.translate('xpack.transform.clone.fetchErrorPromptText', {
        defaultMessage: 'Could not fetch the Kibana data view ID.'
      }));
    } else {
      setSavedObjectId(dataViewId);
    }
  }, [dataViewId, setSavedObjectId]);
  (0, _react.useEffect)(() => {
    if (searchItemsError !== undefined) {
      setTransformConfig(undefined);
      setErrorMessage(searchItemsError);
      setIsInitialized(true);
    }
  }, [searchItemsError]);
  const {
    data: transformConfigs,
    error
  } = (0, _hooks.useGetTransform)(transformId, searchItemsError === undefined);
  (0, _react.useEffect)(() => {
    if (error !== null && error.message !== errorMessage) {
      setTransformConfig(undefined);
      setErrorMessage(error.message);
      setIsInitialized(true);
      return;
    }
    if (transformConfigs !== undefined) {
      try {
        setTransformConfig((0, _transform.overrideTransformForCloning)(transformConfigs.transforms[0]));
        setErrorMessage(undefined);
        setIsInitialized(true);
      } catch (e) {
        setTransformConfig(undefined);
        if (e.message !== undefined) {
          setErrorMessage(e.message);
        } else {
          setErrorMessage(JSON.stringify(e, null, 2));
        }
        setIsInitialized(true);
      }
    }
  }, [error, errorMessage, transformConfigs]);
  const docsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: esTransform,
    target: "_blank",
    iconType: "help",
    "data-test-subj": "documentationLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformsWizard.transformDocsLinkText",
    defaultMessage: "Transform docs"
  }));
  return /*#__PURE__*/_react.default.createElement(_capabilities_wrapper.CapabilitiesWrapper, {
    requiredCapabilities: ['canGetTransform', 'canPreviewTransform', 'canCreateTransform', 'canStartStopTransform']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformsWizard.cloneTransformTitle",
      defaultMessage: "Clone transform"
    }),
    rightSideItems: [docsLink],
    bottomBorder: true,
    paddingSize: 'none'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    "data-test-subj": "transformPageCloneTransform",
    paddingSize: 'none'
  }, typeof errorMessage !== 'undefined' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.transform.clone.errorPromptTitle', {
      defaultMessage: 'An error occurred getting the transform configuration.'
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(errorMessage))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null, searchItems !== undefined && isInitialized === true && transformConfig !== undefined && /*#__PURE__*/_react.default.createElement(_wizard.Wizard, {
    cloneConfig: transformConfig,
    searchItems: searchItems
  })));
};
exports.CloneTransformSection = CloneTransformSection;