"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.App = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactQuery = require("@tanstack/react-query");
var _eui = require("@elastic/eui");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("./common/constants");
var _clone_transform = require("./sections/clone_transform");
var _create_transform = require("./sections/create_transform");
var _transform_management = require("./sections/transform_management");
var _serverless_context = require("./serverless_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = ({
  history
}) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
  history: history
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/${_constants.SECTION_SLUG.CLONE_TRANSFORM}/:transformId`,
  component: _clone_transform.CloneTransformSection
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/${_constants.SECTION_SLUG.CREATE_TRANSFORM}/:savedObjectId`,
  component: _create_transform.CreateTransformSection
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/`,
  component: _transform_management.TransformManagementSection
})));
exports.App = App;
const renderApp = (element, appDependencies, enabledFeatures, experimentalFeatures) => {
  const I18nContext = appDependencies.i18n.Context;
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        staleTime: Infinity,
        retry: false
      }
    }
  });
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: appDependencies.theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: appDependencies
  }, /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_serverless_context.EnabledFeaturesContextProvider, {
    enabledFeatures: enabledFeatures
  }, /*#__PURE__*/_react.default.createElement(_serverless_context.ExperimentalFeaturesContextProvider, {
    experimentalFeatures: experimentalFeatures
  }, /*#__PURE__*/_react.default.createElement(App, {
    history: appDependencies.history
  })))))))), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
};
exports.renderApp = renderApp;